#ifndef _NR_UTILS_YFAN_H_
#define _NR_UTILS_YFAN_H_



void nrerror(char error_text[]);
float *vector(long nh);
int *ivector( long nh);
unsigned char *cvector(long nh);
unsigned long *lvector(long nh);
double *dvector(long nh);
float **matrix(long nrh, long nch);
double **dmatrix(long nrh, long nch);
int **imatrix(long nrh, long nch);
char **cmatrix(long nrh, long nch);
float **submatrix(float **a, long oldrl, long oldrh, long oldcl, long oldch, long newrl, long newcl);
unsigned char ***c3tensor(long nrh, long nch, long ndh);
char ***cc3tensor(long nrh, long nch, long ndh);
int ***i3tensor(long nrh,long nch,long ndh);
short ***s3tensor(long nrh,long nch,long ndh);
float ***f3tensor(long nrh,long nch,long ndh);
double ***d3tensor(long nrh,long nch,long ndh);
float ****f4tensor(long nrh,long nch,long ndh,long nth);
short ****i4tensor(long nrh, long nch, long ndh, long nth);
short ****s4tensor(long nrh, long nch, long ndh, long nth);
float *****f5tensor(long nrh,long nch,long ndh,long nth,long nsh);
short *****s5tensor(long nrh,long nch,long ndh,long nth,long nsh);
void free_vector(float *v, long nh);
void free_ivector(int *v, long nh);
void free_cvector(unsigned char *v,  long nh);
void free_lvector(unsigned long *v,  long nh);
void free_dvector(double *v,  long nh);
void free_matrix(float **m,  long nrh,  long nch);
void free_dmatrix(double **m,  long nrh,  long nch);
void free_imatrix(int **m, long nrh,  long nch);
void free_cmatrix(char **m, long nrh, long nch);
void free_submatrix(float **b, long nrl, long nrh, long ncl, long nch);
void free_c3tensor(unsigned char ***t, long nrh,long nch,long ndh);
void free_cc3tensor(char ***t, long nrh, long nch, long ndh);
void free_i3tensor(int ***t, long nrh,long nch,long ndh);
void free_s3tensor(short ***t, long nrh,long nch,long ndh);
void free_f3tensor(float ***t, long nrh, long nch, long ndh);
void free_d3tensor(double ***t, long nrh, long nch, long ndh);
void free_f4tensor(float ****t, long nrh, long nch, long ndh, long nth);
void free_i4tensor(short ****t, long nrh, long nch, long ndh, long nth);
void free_s4tensor(short ****t, long nrh, long nch, long ndh, long nth);
void free_f5tensor(float *****t, long nrh, long nch, long ndh, long nth, long nsh);
void free_s5tensor(short *****t, long nrh, long nch, long ndh, long nth, long nsh);
void indexx(long n, float arr[], unsigned long indx[]);

#endif /* _NR_UTILS_H */
