#!/bin/bash

# This is the main file to test a classifier

# last modified : Oct 7, 2008 by Stathis Kanterakis
# yong.fan@ieee.org, kanterae@uphs.upenn.edu

SVNFILEVER="$Id: Compare_test.sh 109 2012-03-26 18:44:41Z schuha@UPHS.PENNHEALTH.PRV $";
SVN_REV="";
EXEC_NAME="Compare_test";
RELEASE_ID="0.3.1";

# Set the PATH to include the libexec directory for the package...this should be relative to the installation
# directory of this script
basedir=`dirname $0`
libexec=${basedir}/../libexec
if [ ! -d $libexec ] ; then
	echo "Could not find libexec directory at \"$libexec\"" 1>&2 
	exit 1
fi

# check for required executables
for exe in COMPARE_extract COMPARE_check_input COMPARE_average_score COMPARE_build COMPARE_build_loo COMPARE_build_check COMPARE_SVM_discriminate COMPARE_map_svm_diff_to_region COMPARE_float_sum COMPARE_float_sum_m COMPARE_model COMPARE_score_mean COMPARE_score_sum 
do
	if [ ! -e ${libexec}/$exe ] ; then
		echo "Could not find required executable \"$exe\" in \"$libexec\"" 1>&2
		exit 1
	fi
done

# We're OK to go on...
export PATH="${libexec}:${PATH}"

version(){
  echo " $EXEC_NAME Version information";
  echo "  Release          : $RELEASE_ID";
  echo "  Svn Revision     : $SVN_REV";
  echo "  Svn File Version : $SVNFILEVER";
}

usage() {
  echo
  echo "  This program classifies the samples in data_list_file using model_file, and outputs SVM scores to result_file";
  echo
  echo "  Usage: $EXEC_NAME (model_file) (data_list_file) (result_file)";
  echo "  Usage: $EXEC_NAME [-v/h/u]";
	echo
  echo "  Required parameters:";
  echo "    model_file       : the classifier constructed by Compare";
  echo "    data_list_file   : input file containing the test set";
  echo "                       this file must list raw image data files of datatype short";
  echo "    result_file      : classification scores for each input subject";
  echo
  echo "  Optional parameters:";
  echo "    [-v]   version information";
  echo "    [-h]   this message";
  echo "    [-u]   this message";
  echo
  echo  " Note:  COMPARE extracts features directly from .img files and does not read corresponding header files; please make sure that all image are 'signed-short' (2-byte) images and all have the same orientation and registered to the same template. In addition, class labels are either '1' or '-1'."; 
  echo 
  echo "  More information:";
  echo "    https://www.rad.upenn.edu/sbia/software/";
  echo "    sbia-software@uphs.upenn.edu";
	echo
}

checkandexit(){
  if [ $1 != 0 ] ; then
    # There was an error, bail out!
    echo "$2" 1>&2
    exit $1
  fi
}

if [ $# -ne 3 ]; then
  while getopts vhu opt
  do
   case "$opt" in
      v) version; exit 0;;
      h) usage; exit 0;;
      u) usage; exit 0;;
      *) usage; exit 1;;
    esac
  done
  usage;
  exit 1;
fi

model_file=$1;
test_file=$2;
result_file=$3;


echo
echo " checking model file ...";

#decompress the model files
if [ -e $model_file ]
 then
  tar -zxvf $model_file > a.log
 else
  echo "Could not open model file $model_file.";
  exit 1;
fi

file_num_feature="COMPARE_f_num_feature.bin" ;

if [ -e $file_num_feature ]
   then
     read f_num_feature < $file_num_feature ;
     #echo $f_num_feature;
   else
   echo "could not open input of model";
   exit 1;
fi   
rm $file_num_feature

train_para="train_para.txt";
if [ -e $train_para ]
 then
    for i in 1 2 3 4 5 6
    do
     if [ $i -eq 1 ]; then 
	    read train_root_dir;
     fi
   
     if [ $i -eq 2 ]; then 
	    read train_num_subj 
     fi
    
     if [ $i -eq 3 ]; then
	    read train_num_feat
     fi

     if [ $i -eq 4 ]; then
	    read xdim  
     fi
    
     if [ $i -eq 5 ]; then
	    read ydim  
     fi

     if [ $i -eq 6 ]; then
	    read zdim 
     fi
    done < $train_para
 else
   echo "could not open input of model";
   exit 1;
fi   

rm $train_para

echo " checking input ...";
#echo " COMPARE_check_input $test_file 0";
COMPARE_check_input $test_file  0
checkandexit $? "Error checking input!"

base_dir=`pwd`;
train_file_base="r_roi_train";
test_file_base="r_roi_test";

echo " classifying testing subjects ...";
#test models on test data set

test_para="train_para.txt";
    if [ -e $test_para ]
	then
	    for i in 1 2 3 4 5 6
	    do
	    if [ $i -eq 1 ]; then 
		    read test_root_dir;
	    fi
	    
	    if [ $i -eq 2 ]; then 
		    read test_num_subj 
	    fi
	    
	    if [ $i -eq 3 ]; then
		    read test_num_feat
	    fi
	    
	    if [ $i -eq 4 ]; then
		    read xdim  
		  fi
		
	    if [ $i -eq 5 ]; then
		    read ydim  
	    fi
	    
	    if [ $i -eq 6 ]; then
		    read zdim 
	    fi
	    done < $test_para
	 else
	    echo "could not open input for testing";
	    exit 1;
    fi   

start_id=0;
end_id=$(( $test_num_feat - 1 ));
num_subject=$test_num_subj;
data_root_dir=$test_root_dir;
sublist_base="train_sub";

j=0;

  while [ $j -lt $f_num_feature ]
   do

    i=0

    while [ $i -lt $train_num_subj ]
     do
       base_dir=`pwd`;
       feature_location_file="${base_dir}/r_roi_feature_location_${i}.txt";
       region_file="${base_dir}/r_roi_region_${i}";
       feature_order="${base_dir}/order_${i}.bin";
       svm_model_file="${base_dir}/svm_model_${i}_${j}.bin";

       COMPARE_model $test_file $region_file $feature_location_file $feature_order $svm_model_file > a.log
       checkandexit $? "Error classifying test subjects: `cat a.log | tail -1`!"
       
       test_score_file="test_score_file_${i}.txt";
       mv svm_score.bin $test_score_file
    
       i=$(( $i + 1 ));
      done
    
     test_result_file="${result_file}";
   
     COMPARE_average_score test_score_file $train_num_subj $num_subject $test_result_file > a.log
     checkandexit $? "Error averaging test scores: `cat a.log | tail -1`!"
     
      if [ $j == "0" ]; then
        cp $test_result_file tmp_${test_result_file}   
      else
        COMPARE_score_sum $test_result_file tmp_${test_result_file} $num_subject
        checkandexit $? "Error summing scores!"
      fi
    
      j=$(( $j + 1 ));
    
  done 


COMPARE_score_mean $test_result_file tmp_${test_result_file} $num_subject $f_num_feature
checkandexit $? "Error computing test mean!"
  
rm tmp_${test_result_file}
rm test_score_file_*.txt
rm train_sub* train_para.txt

rm r_roi_feature_*.txt r_roi_region_*.bin order_*.bin svm_model_*.bin 
rm a.log

echo " finished.";

exit 0;
