/*******************************************************

Feature Extraction Class.

last modified : Jul 26, 2007

yong.fan@ieee.org

*******************************************************/

#ifndef _FEATUREEXTRACTION_MODEL_H_
#define _FEATUREEXTRACTION_MODEL_H_
#define True  1
#define False 0
#include "nrutil_compare.h"
#include <math.h>
#include <string.h>
//#include <ieeefp.h>


class FeatureExtraction_model {
  
 public:
 
  int  _DebugFlag;

  /// Constructor
  FeatureExtraction_model();

  /// Destructor
  ~FeatureExtraction_model();

  /// Returns the name of the class
  char *NameOfClass();

  /// Prints debugging messages if debugging is enabled
  void Debug(char *);


 public:
  
  char *_file_sublist;
  char ***_file_name;
  float *_label;
  
  int _num_subject;
  
  int  _xdim;
  int  _ydim;
  int  _zdim;
  long _im_size;
  long _num_feature;

  long _total_num_feature;
  long _num_classification_feature; 
  char *_data_root_dir;
  
  float ****_feature_data;  // store the features of all the subjects [sub][x][y][z];
  
  short ****_r_region;
  void GetROIFeature();
  void ComputeRegionFeat(int feat);
  
  int **_ranked_feature_location; // store the ranked feature location [feature_index][feature + feature coordination];
  int **_region_feature_location; // store the region feature location
  int **_w_roi_feature_location;    // store the roi feature location from wathershed segmentation
  int **_r_roi_feature_location;    // store the roi feature location from region growing

  float **_r_roi_feature;

  float ***_r_roi_volume;
  float **_r_roi_size;
  
  float **_whitten_para;
  
  // Comput the feature score without subject_id  
  void ReadOrderFile();
  void ReadFeatureLocation();
  void GetFeature(int feat);
  void RankROIFeature();
  void WriteFiles();
  
  /// Write Feature locations and their corresponding score
  void WriteFeatureLocations();
  void WriteRegionFiles();
  void  SVMClassification( );
 
  
  void ReadData(int feat);
  void FeatureWhitten( );

  /// Determing the data point is not noise
  int IsValidVector(float *x, float *y, int len);
  int IsValidVector(int *x, int *y, int len);
  
  char *_region_file_base;
  char *_feature_location_file;
  char *_feature_order_file;
  char *_svm_model_file;
  int *_order;

  /// Sets input for the feature selection routine
  void  SetInput (char *sublist, char *region_file_base, char *feature_location_file, char *feature_order_file, char *svm_model_file);
  void GetInput();	 
  /// Initial set up for the feature selection
  void Initialize();
  /// Final set up for the feature selection
  void Finalize();
  void Run(); 

};

inline void FeatureExtraction_model::Debug(char *message)
{
  if (_DebugFlag == True) printf("\n %s \n", message);
}


#endif
