#ifndef WATERSHED_H
#define WATERSHED_H

#include "queue.h"
#include "nrutil_compare.h"
#include <math.h>
#include <stdlib.h>
#include <stdio.h>


#define INIT -1
#define MASK -2
#define WSHED 0
#define FICTITIOUS -1

/*
 * Instantiate compute_watershed_vs_TYPE functions.
 */

#undef TYPE
#define DO_NAN_CHECK 0

void compute_watershed(float *I, int **coor, int N, int xdim, int ydim, int zdim, unsigned long *sort_index, long *L);
void watershed(float ***im, int xdim, int ydim, int zdim, short ***water,float gaussian);
void watershed_post(float ***im, short ***water, float ***result,int xdim, int ydim, int zdim);
void gaussian_smooth(float ***image, int xdim, int ydim, int zdim, float sigma, float ***smoothedim);
void gaussian_smooth_mask(float ***image, int xdim, int ydim, int zdim, float sigma, float ***smoothedim, unsigned char ***mask);

#endif
