/*!
 * \file  COMPARE_SVM_rfe.h
 * \brief This is head file for SVM-rfe.
 *
 * For copyright information please see Copyright.txt in the root
 * directory of the project.
 *
 * Contact: SBIA Group <sbia-software@uphs.upenn.edu>
 */


#ifndef COMPARE_SVM_RFE_INC
#define COMPARE_SVM_RFE_INC

#include "SVM.h"
#include "UserKernel.h"

class SVMrfe : public SVM
{
 private:
  
  real C;
  void prepareToLauch();
  void autoAll();
  bool svm_is_ready;
  bool support_vectors_is_ready;
  int lm;
  real eps_regression;
  real cache_size_meg;

  public:

  int n_support_vectors;
  int n_support_vectors_bound;
  int *support_vectors;
  real *sv_alpha;
  
  // scores for every feature 
  void scorecomputation_diff(real *feature_score);
  void scorecomputation_forward_diff(real *feature_score, real **data_, int n_input_dim_);
  void scorecomputation_forward(real *feature_score, real **data_, int n_input_dim_);
  void scorecomputation_zero(real *feature_score);
  
  bool regression_mode;
  
  SVMrfe();
  
  virtual void analyticSolve(int xi, int xj);
  virtual void setOption(const string& optionname, const string& value);
  
  void train(real **data_, sreal **sdata_, real *target_, int l_, int n_input_dim_);
  real use(real *x);
  real use(sreal *x);
  
  void save(string file, string comment);
  void load(string file);
  
  ~SVMrfe();

};

#endif
