/*!
 * \file  COMPARE_model.cc
 * \brief This program tests new samples using the SVM classier.
 *
 * For copyright information please see Copyright.txt in the root
 * directory of the project.
 *
 * Contact: SBIA Group <sbia-software@uphs.upenn.edu>
 */


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "FeatureExtraction_model.h"
#include <getopt.h>

#include "SbiaCOMPAREConfig.h"

#define EXEC_NAME "COMPARE_model"

void version(){
  printf("\n\n%s Version information\n",EXEC_NAME);
  printf("  Version:  %s\n", SBIA_COMPARE_VERSION);
#if SBIA_COMPARE_REVISION
  printf("  Revision: %s\n", SBIA_COMPARE_REVISION);
#endif
}


void usage(){
  printf("\n This program tests new samples using the SVM classier.\n");

  printf("\n Usage: %s (subject_list) (region_file_base) (feature_location_file) (feature_order_file) (svm_model_file)",EXEC_NAME);
  printf("\n Usage: %s [-u/h/v]\n",EXEC_NAME);
  
  printf("\n Required arguments:");
  printf("\n   subject_list           : input file of samples to be classified");
  printf("\n   region_file_base       : prefix of region feature files (ex. r_roi_region_0)");
  printf("\n   feature_location_file  : name of the file storing the regional feature location information (ex. r_roi_feature_location_0.txt)");
  printf("\n   feature_order_file     : name of the file storing the feature order inforamtion (ex. order_0.bin)");
  printf("\n   svm_model_file         : name of the SVM classifier (ex. svm_model_0_0.bin)\n");
  
  printf("\n Optional arguments:\n");
  printf("\n   [-u      --usage]     Display this message");
  printf("\n   [-h       --help]     Display this message");
  printf("\n   [-v    --version]     Display version information\n");
  
  printf("\n More information:");
  printf("\n   https://www.rad.upenn.edu/sbia/software/");
  printf("\n   sbia-software@uphs.upenn.edu");
  printf("\n\n");
}


int main(int argc, char *argv[])
{
  
  static struct option long_options[] =
  {
    {"usage",       no_argument,            0, 'u'},
    {"help",        no_argument,            0, 'h'},
    {"version",     no_argument,            0, 'v'},
    {0, 0, 0, 0}
  };

  int c, option_index = 0;

  if(argc!=6){
    while ( (c = getopt_long (argc, argv, "uhv",
                long_options,&option_index)) != -1){
      switch (c)
      {
        case 'v':
          version();
          return 0;

        case 'u':
          usage();
          return 0;

        case 'h':
          usage();
          return 0;

        case '?':
          /* getopt_long already printed an error message. */
          break;

        default:
          return 1;
      }
    }
    usage();
    exit(1);
  }
  
  char *sublist  = argv[1];
  argc--;
  argv++;
  char *region_file_base = argv[1];
  argc--;
  argv++;
  char *feature_location_file = argv[1];
  argc--;
  argv++;
  char *feature_order_file = argv[1];
  argc--;
  argv++;
  char *svm_model_file = argv[1];
  argc--;
  argc++;

  printf("\n The input options are below:"); 
  printf("\n ===============================================\n");
  printf("\n sublist:                 %s",sublist);
  printf("\n region_file_base:        %s",region_file_base);
  printf("\n feature_location_file:   %s",feature_location_file);
  printf("\n feature_order_file:      %s",feature_order_file);
  printf("\n svm_model_file:          %s",svm_model_file);
  printf("\n ==============================================\n");
  
  FeatureExtraction_model *featExt = new FeatureExtraction_model; 
  
  featExt->SetInput (sublist, region_file_base, feature_location_file, feature_order_file, svm_model_file);
  featExt->Run();
  
  return 0;
}
  

