##############################################################################
# \file  SbiaPackage.cmake
# \brief CPack configuration.
#
# This file is included at the bottom of the root CMake file of any SBIA
# project, in particular after the sbia_project () macro call as it makes
# use of some PROJECT_* variables and includes the CPack module, which
# utilizes the configuration of the installation tree to package the software.
#
# DO NOT edit this file. Instead, overwrite the package information either
# in the file Package.cmake or the file Package.cmake.in located in the top
# directory of the source tree. The latter is configured and copied to the
# binary tree before included by this module. Further, to enable a
# component-based installation, provide either the file Components.cmake or
# Components.cmake.in in the top directory of the source tree. Again, the
# latter is configured via CMake's configure_file () before use.
#
# Components can be added using the CPack command cpack_add_component ().
# Several components can be grouped together and a group description be added
# using the command cpack_add_component_group (). Different pre-configured
# install types which define a certain selection of components to install
# can be added using cpack_add_install_type ().
#
# \see CPack.cmake
#
# For copyright information please see Copyright.txt in the root
# directory of the project.
#
# Contact: SBIA Group <sbia-software@uphs.upenn.edu>
##############################################################################

# ============================================================================
# system libraries
# ============================================================================

# install required runtime libraries
include (InstallRequiredSystemLibraries)

# ============================================================================
# package information
# ============================================================================

# Provide specific information of the software package in the project's own
# Package.cmake file in the top directory of either the binary tree or the
# source tree.

set (CPACK_PACKAGE_NAME                "${PROJECT_NAME}")
set (CPACK_PACKAGE_VERSION_MAJOR       "${PROJECT_VERSION_MAJOR}")
set (CPACK_PACKAGE_VERSION_MINOR       "${PROJECT_VERSION_MINOR}")
set (CPACK_PACKAGE_VERSION_PATCH       "${PROJECT_VERSION_PATCH}")
set (CPACK_PACKAGE_VERSION             "${PROJECT_VERSION}")
set (CPACK_PACKAGE_VENDOR              "${PROJECT_PACKAGE_VENDOR}")
set (CPACK_PACKAGE_DESCRIPTION_SUMMARY "${PROJECT_DESCRIPTION}")
set (CPACK_PACKAGE_DESCRIPTION_FILE    "${PROJECT_README_FILE}")
set (CPACK_RESOURCE_FILE_README        "${PROJECT_README_FILE}")
set (CPACK_RESOURCE_FILE_LICENSE       "${PROJECT_LICENSE_FILE}")

set (CPACK_GENERATOR                   "STGZ" "TGZ")
set (CPACK_SOURCE_GENERATOR            "TGZ")
set (CPACK_INCLUDE_TOPLEVEL_DIRECTORY  "1")

# ----------------------------------------------------------------------------
# \todo The proper values for the following options still needs to be
#       figured. For the moment, just ignore these settings. NSIS might
#       anyways not be supported in the near future.
# ----------------------------------------------------------------------------

if (WIN32 AND NOT UNIX)
  # There is a bug in NSI that does not handle full unix paths properly. Make
  # sure there is at least one set of four (4) backlasshes.
#  set (CPACK_PACKAGE_ICON             "${CMake_SOURCE_DIR}/Utilities/Release\\\\InstallIcon.bmp")
#  set (CPACK_NSIS_INSTALLED_ICON_NAME "bin\\\\MyExecutable.exe")
#  set (CPACK_NSIS_DISPLAY_NAME        "${CPACK_PACKAGE_INSTALL_DIRECTORY} ${PROJECT_NAME}")
#  set (CPACK_NSIS_HELP_LINK           "http:\\\\\\\\www.my-project-home-page.org")
#  set (CPACK_NSIS_URL_INFO_ABOUT      "http:\\\\\\\\www.my-personal-home-page.com")
  set (CPACK_NSIS_CONTACT             "sbia-software@uphs.upenn.edu")
  set (CPACK_NSIS_MODIFY_PATH         "ON")
else ()
#  set (CPACK_STRIP_FILES        "bin/MyExecutable")
#  set (CPACK_SOURCE_STRIP_FILES "")
endif ()

# ============================================================================
# source package
# ============================================================================

# \see CPack.cmake

set (
  CPACK_SOURCE_IGNORE_FILES
    "${CPACK_SOURCE_IGNORE_FILES}"
	"/CVS/"
	"/.svn/"
	".swp$"
	".#"
	"/#"
	".*~"
	"cscope.*"
	"[b|B]uild"
	"[I|i]nstallation"
)

# ============================================================================
# project specific package information
# ============================================================================

if (EXISTS "${PROJECT_SOURCE_DIR}/Package.cmake.in")
  configure_file ("${PROJECT_SOURCE_DIR}/Package.cmake.in" "${PROJECT_BINARY_DIR}/Package.cmake" @ONLY)
  include ("${PROJECT_BINARY_DIR}/Package.cmake")
elseif (EXISTS "${PROJECT_SOURCE_DIR}/Package.cmake")
  include ("${PROJECT_SOURCE_DIR}/Package.cmake")
endif ()

# ============================================================================
# build package
# ============================================================================

include (CPack)

# ============================================================================
# components
# ============================================================================

# Components can be added using the CPack command cpack_add_component ().
# Several components can be grouped together and a group description be added
# using the command cpack_add_component_group (). Different pre-configured
# install types which define a certain selection of components to install
# can be added using cpack_add_install_type ().
#
# \see CPack.cmake
# \see http://www.vtk.org/Wiki/CMake:Component_Install_With_CPack#Component-Based_Installers_with_CPack

if (EXISTS "${PROJECT_SOURCE_DIR}/Components.cmake.in")
  configure_file ("${PROJECT_SOURCE_DIR}/Components.cmake.in" "${PROJECT_BINARY_DIR}/Components.cmake" @ONLY)
  include ("${PROJECT_BINARY_DIR}/Components.cmake")
elseif (EXISTS "${PROJECT_SOURCE_DIR}/Components.cmake")
  include ("${PROJECT_SOURCE_DIR}/Components.cmake")
endif ()
