package edu.vanderbilt.masi.LabelFusion;

public class MajorityVote extends VotingFusionBase {
	
	public MajorityVote (ObservationBase obs_in) {
		// take in the input arguments
		obs = obs_in;
		fast = 0;
	}
	
	public MajorityVote (ObservationBase obs_in, int fast_in) {
		// take in the input arguments
		obs = obs_in;
		fast = fast_in;
		estimate = new int [obs.dims[0]][obs.dims[1]][obs.dims[2]];
	}
	
	public int [][][] run () {
		
		if (fast == 0) {
			// get the per voxel votes
			W = new double [obs.dims[0]][obs.dims[1]][obs.dims[2]][obs.num_labels][1];
			set_voxelwise_data(W);
			
			// set the estimate
			set_estimate_from_voxelwise_data(W);
		} else {
			// iterate over every voxel
			for (int x = 0; x < obs.dims[0]; x++)
				for (int y = 0; y < obs.dims[1]; y++)
					for (int z = 0; z < obs.dims[2]; z++) {
						double [] labelprobs = new double [obs.num_labels];
						obs.iterate_voxel(new VotingVoxelAdd(labelprobs), x, y, z);
						estimate[x][y][z] = get_estimate_value(labelprobs);
					}
		}
		
		// return the estimate
		return(estimate);
	}
}
