#ifndef NonLocalSTAPLE_H
#define NonLocalSTAPLE_H

void usage();

void set_input_args(int argc,
                    char ** argv,
                    char ** obsfile,
                    char ** imsfile,
                    char ** targfile,
                    intensity_t * epsilon,
                    size_t * ns,
                    size_t * nsf,
                    size_t * nc,
                    intensity_t * stdev,
                    intensity_t * sp_stdev,
                    char ** priorfile,
                    char ** out_prefix,
                    size_t * num_keep,
                    bool * save_labelprobs,
                    bool * save_theta);

void print_input_parms(char * obsfile,
                       char * imsfile,
                       char * targfile,
                       char * priorfile,
                       size_t * dims,
                       size_t * ns,
                       size_t * nc,
                       intensity_t stdev,
                       intensity_t sp_stdev,
                       size_t num_raters,
                       size_t num_labels,
                       size_t num_keep);

void initialize_consensus_estimate(bool *** consensus,
                                   label_t **** obs,
                                   label_t *** estimate,
                                   size_t * ns,
                                   size_t * dims,
                                   size_t num_raters,
                                   size_t num_labels);

void allocate_non_local(label_t ***** obsnl,
                        intensity_t ***** alphanl,
                        bool *** consensus,
                        size_t * dims,
                        size_t num_raters,
                        size_t num_keep);

void allocate_W(intensity_t **** W,
                size_t * dims,
                size_t num_labels);

void allocate_theta(intensity_t *** theta,
                    size_t num_labels,
                    size_t num_raters);

void set_nonlocal_data(label_t **** obs,
                       label_t ***** obsnl,
                       intensity_t ***** alphanl,
                       intensity_t **** ims,
                       intensity_t *** target,
                       bool *** consensus,
                       size_t * dims,
                       size_t * ns,
                       size_t * nc,
                       size_t * nsf,
                       size_t num_raters,
                       size_t num_keep,
                       intensity_t stdev,
                       intensity_t sp_stdev);

void set_alpha_for_voxel(int x,
                         int y,
                         int z,
                         size_t num_raters,
                         size_t num_keep,
                         size_t * dims,
                         size_t * ns,
                         size_t * nc,
                         intensity_t ff,
                         label_t ***** obsnl,
                         label_t ** obsr,
                         label_t **** obs,
                         intensity_t ***** alphanl,
                         intensity_t ** alphar,
                         intensity_t *** dist_factor,
                         intensity_t **** ims,
                         intensity_t *** target);

void set_dist_factor(size_t * nsf,
                     size_t * ns,
                     intensity_t sp_stdev,
                     intensity_t *** dist_factor);

void set_initial_theta(intensity_t *** theta,
                       size_t num_raters,
                       size_t num_labels);

void normalize_theta(intensity_t *** theta,
                     size_t num_raters,
                     size_t num_labels);

void reset_theta(intensity_t *** theta,
                 intensity_t *** theta_prev,
                 size_t num_raters,
                 size_t num_labels);

intensity_t calc_convergence_factor(intensity_t *** theta,
                                    intensity_t *** theta_prev,
                                    size_t num_raters,
                                    size_t num_labels);

intensity_t get_norm_diff(int x,
                          int y,
                          int z,
                          int xp,
                          int yp,
                          int zp,
                          size_t j,
                          size_t * dims,
                          size_t * nc,
                          intensity_t **** ims,
                          intensity_t *** target);

void run_EM_for_voxel(size_t x,
                      size_t y,
                      size_t z,
                      size_t num_raters,
                      size_t num_labels,
                      size_t num_keep,
                      size_t prior_type,
                      label_t ***** obsnl,
                      label_t *** estimate,
                      intensity_t ***** alphanl,
                      intensity_t *** theta,
                      intensity_t *** theta_prev,
                      intensity_t * lp,
                      intensity_t * pval,
                      intensity_t ** jsum);

void run_NonLocalSTAPLE(label_t ***** obsnl,
                        intensity_t ***** alphanl,
                        label_t *** estimate,
                        intensity_t *** theta,
                        intensity_t **** prior,
                        intensity_t **** W,
                        intensity_t epsilon,
                        bool *** consensus,
                        size_t * dims,
                        size_t num_raters,
                        size_t num_labels,
                        size_t num_keep);

void save_results(size_t * dims,
                  char * outfile,
                  char * targfile,
                  label_t *** estimate);

#endif
