#ifndef OutOfAtlasLabeling_H
#define OutOfAtlasLabeling_H

void usage();

void set_input_args(int argc,
                    char ** argv,
                    char ** obsfile,
                    char ** imsfile,
                    char ** targfile,
                    char ** estfile,
                    size_t * ns,
                    size_t * num_bins,
                    float * stdev,
                    char ** outfile);

void print_input_parms(char * obsfile,
                       char * imsfile,
                       char * targfile,
                       char * estfile,
                       size_t * dims,
                       size_t * ns,
                       size_t num_bins,
                       size_t num_raters,
                       size_t num_labels,
                       float stdev);

void set_label_densities(label_t **** obs,
                         intensity_t **** ims,
                         intensity_t * xi,
                         intensity_t ** dens,
                         float stdev,
                         const size_t * dims,
                         const size_t num_raters,
                         const size_t num_labels,
                         const size_t num_bins);

intensity_t get_err_val(intensity_t *** target,
                        label_t *** est,
                        intensity_t ** dens,
                        intensity_t * target_dens,
                        intensity_t * atlas_dens,
                        intensity_t * diff_dens,
                        intensity_t * xi,
                        float stdev,
                        size_t * num_app,
                        const size_t * dims,
                        const size_t * ns,
                        const size_t num_bins,
                        const size_t num_labels,
                        const size_t x,
                        const size_t y,
                        const size_t z);

void run_anomaly_detection(intensity_t *** target,
                           label_t **** obs,
                           intensity_t **** ims,
                           label_t *** est,
                           intensity_t *** errim,
                           float stdev,
                           const size_t * dims,
                           const size_t * ns,
                           const size_t num_bins,
                           const size_t num_raters,
                           const size_t num_labels);

void save_outfile(char * targfile,
                  char * outfile,
                  intensity_t *** errim,
                  const size_t * dims);

#endif
