
// Utilities and system includes
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <nifti1_io.h>
#include <nifti1.h>
#include "fusion_io.h"
#include "fusion_tools.h"
#include "OutOfAtlasLabeling.h"

////////////////////////////////////////////////////////////////////////////////
// Main program
////////////////////////////////////////////////////////////////////////////////
int main(int argc,
         char ** argv)
{
    // initialize some variables
    intensity_t *** target = NULL,
                **** ims = NULL,
                *** errim = NULL;
    label_t *** est = NULL,
            **** obs = NULL;
    char * targfile = NULL,
         * imsfile = NULL,
         * estfile = NULL,
         * obsfile = NULL,
         * outfile = NULL;
    size_t num_raters = 0,
           num_labels = 0,
           num_bins = 64,
           num_coef = 3,
           * dims = NULL,
           * ns = NULL;
    float stdev = 0.1;
    intensity_t rho = 0;

    // allocate some memory
    dims = (size_t *)malloc(3 * sizeof(*dims));
    ns = (size_t *)malloc(3 * sizeof(*ns));
    for (size_t i = 0; i < 3; i++)
        ns[i] = 3;

    // set the input arguments
    set_input_args(argc, argv, &obsfile, &imsfile, &targfile, &estfile,
                   ns, &num_bins, &stdev, &outfile);

    // read the data from the input files
    fprintf(stdout, "-> Reading the target image.\n");
    target = get_target(targfile, dims);
    fprintf(stdout, "-> Reading the atlas label obversations.\n");
    obs = get_obs(obsfile, dims, &num_raters, &num_labels);
    fprintf(stdout, "-> Reading the atlas intensities.\n");
    ims = get_ims(imsfile, dims, num_raters);
    fprintf(stdout, "-> Reading the target segmentation estimate.\n");
    est = get_est(estfile, dims, num_labels);

    // print the parameters to the screen
    fprintf(stdout, "-> Parsed Input Parameters:\n");
    print_input_parms(obsfile, imsfile, targfile, estfile, dims, ns,
                      num_bins, num_raters, num_labels, stdev);

    // allocate space for the error image
    errim = (intensity_t ***)malloc(dims[0] * sizeof(*errim));
    for (size_t x = 0; x < dims[0]; x++) {
        errim[x] = (intensity_t **)malloc(dims[1] * sizeof(*errim[x]));
        for (size_t y = 0; y < dims[1]; y++) {
            errim[x][y] = (intensity_t *)malloc(dims[2] *
                                                 sizeof(*errim[x][y]));
        }
    }

    // normalize the intensity
    fprintf(stdout, "-> Normalizing intensity\n");
    normalize_intensity(target, est, ims, obs, dims, num_raters,
                        num_labels, num_coef, rho);

    // run the anomaly detection algorithm
    run_anomaly_detection(target, obs, ims, est, errim, stdev, dims, ns,
                          num_bins, num_raters, num_labels);

    // save the output file
    save_outfile(targfile, outfile, errim, dims);

    // free the allocated data
    free_3D_data<intensity_t>(target, dims);
    free_3D_data<intensity_t>(errim, dims);
    free_3D_data<label_t>(est, dims);
    free_4D_data<intensity_t>(ims, dims);
    free_4D_data<label_t>(obs, dims);
    free(dims);
    free(ns);
}

