% An example simulation to test the COLLATE and STAPLE algorithms on a model
% that matches the STAPLE model of rater behavior

% simulation settings
num_raters = 10;
num_slices = 50;
num_labels = 5;
length_im = 100;
length_im_confusion = 32;
lower_lim_diag = 0.45;
upper_lim_diag = 0.65;

% algorithm settings
epsilon = 0.001;
prior_flag = 0;
init_flag = 0;
cons_flag = 0;
alphas = [0 1e10];
cval = 0.95;

% set up the simulation
[obs cms truth] = consensus_simulation_STAPLE_model(num_raters, num_slices, ...
                                                    num_labels, length_im, ...
                                                    length_im_confusion, ...
                                                    lower_lim_diag, ...
                                                    upper_lim_diag);

% run the algorithms
[STAPLE_estimate STAPLE_W STAPLE_theta] = STAPLE(obs, epsilon, ...
                                                 prior_flag, init_flag, ...
                                                 cons_flag);
[COLLATE_estimate COLLATE_W COLLATE_theta] = COLLATE(obs, epsilon, ...
                                                     prior_flag, init_flag, ...
                                                     alphas, cval);

% plot the results
figure(1);
subplot(2, 3, 1);
imagesc(truth(:, :, 1));
title('True Segmentation');
subplot(2, 3, 2);
imagesc(STAPLE_estimate(:, :, 1));
title('STAPLE Estimate');
subplot(2, 3, 3);
imagesc(COLLATE_estimate(:, :, 1));
title('COLLATE Estimate');
subplot(2, 3, 4);
imagesc(cms(:, :, 1), [0 1]);
title('True Confusion Matrix');
subplot(2, 3, 5);
imagesc(STAPLE_theta(:, :, 1), [0 1]);
title('STAPLE Confusion Matrix');
subplot(2, 3, 6);
imagesc(COLLATE_theta(:, :, 1), [0 1]);
title('COLLATE Confusion Matrix');

% print the accuracy levels to the screen
STAPLE_accuracy = fraction_correct(truth, STAPLE_estimate);
disp(['STAPLE Accuracy: ', num2str(STAPLE_accuracy)]);
COLLATE_accuracy = fraction_correct(truth, COLLATE_estimate);
disp(['COLLATE Accuracy: ', num2str(COLLATE_accuracy)]);


