
% algorithm settings
prior_flag = 0;
init_flag = 0;
cons_flag = 0;
epsilon = 0.001;
alphab = [0 100];
cvalb = 0.95;
alphas = [0 2 1e8];
cvals = [0.65 0.95];
num_raters = 8;
dims = [100 100 100];

% create the initial true intensity image
sigx = 2;
sigy = 2;
sigz = 2;
xval = linspace(-10, 10, dims(1));
yval = linspace(-10, 10, dims(2));
zval = linspace(-10, 10, dims(3));
truth_int = add_hump(xval, yval, zval, sigx, sigy, sigz, 1);

% set the truth
truethresh = 0.35;
truth = uint8(truth_int > truethresh);

% add humps
sigx = 1.0;
sigy = 1.0;
sigz = 1.0;
humps = zeros(size(truth_int));

a = 1;
xval = linspace(-10, 10, dims(1));
yval = linspace(-15, 10, dims(2));
zval = linspace(-10, 10, dims(3));
hump1 = add_hump(xval, yval, zval, sigx, sigy, sigz, a);
xval = linspace(-10, 10, dims(1));
yval = linspace(-10, 15, dims(2));
zval = linspace(-10, 10, dims(3));
hump2 = add_hump(xval, yval, zval, sigx, sigy, sigz, a);

sigx = 1.2;
sigy = 1.2;
sigz = 1.2;
a = 1;
xval = linspace(-10, 10, dims(1));
yval = linspace(-25, 10, dims(2));
zval = linspace(-10, 10, dims(3));
hump3 = add_hump(xval, yval, zval, sigx, sigy, sigz, a);
xval = linspace(-10, 10, dims(1));
yval = linspace(-10, 25, dims(2));
zval = linspace(-10, 10, dims(3));
hump4 = add_hump(xval, yval, zval, sigx, sigy, sigz, a);

a = 1;
xval = linspace(-25, 10, dims(1));
yval = linspace(-10, 10, dims(2));
zval = linspace(-10, 10, dims(3));
hump5 = add_hump(xval, yval, zval, sigx, sigy, sigz, a);
xval = linspace(-10, 25, dims(1));
yval = linspace(-10, 10, dims(2));
zval = linspace(-10, 10, dims(3));
hump6 = add_hump(xval, yval, zval, sigx, sigy, sigz, a);

% create the observations
obs = create_obs('volume', dims);
rater_quality_matrix = [0 0 0 0 0 0; ...
                        1 1 1 1 1 1; ...
                        1 0 1 0 1 0; ...
                        1 1 0 1 0 1; ...
                        1 1 0 0 0 0; ...
                        1 0 0 0 0 0; ...
                        0 0 1 1 0 0; ...
                        0 0 1 1 0 0];
for r = 1:num_raters

    data = truth;
    if rater_quality_matrix(r, 1) == 1
        data(hump1 > truethresh) = 0;
    end
    if rater_quality_matrix(r, 2) == 1
        data(hump2 > truethresh) = 0;
    end
    if rater_quality_matrix(r, 3) == 1
        data(hump3 > truethresh) = 1;
    end
    if rater_quality_matrix(r, 4) == 1
        data(hump4 > truethresh) = 1;
    end
    if rater_quality_matrix(r, 5) == 1
        data(hump5 > truethresh) = 1;
    end
    if rater_quality_matrix(r, 6) == 1
        data(hump6 > truethresh) = 1;
    end

    obs = add_obs(obs, uint8(data));

end

% create the true intensity image
truth_int = truth_int + hump1 + hump2 + hump3 + hump4 + hump5 + hump6;


% run the algorithms
[MV_est MV_W] = majority_vote(obs);
[S_est S_W S_theta] = STAPLE(obs, epsilon, prior_flag, init_flag, cons_flag);
[C_est C_W C_theta] = COLLATE(obs, epsilon, prior_flag, init_flag, ...
                              alphab, cvalb);
[MC_est MC_W MC_theta] = COLLATE(obs, epsilon, prior_flag, init_flag, ...
                                 alphas, cvals);

% print the results to the screen
disp(['Majority Vote Accuracy: ', num2str(dice(truth, MV_est))]);
disp(['STAPLE Accuracy: ', num2str(dice(truth, S_est))]);
disp(['Binary-COLLATE Accuracy: ', num2str(dice(truth, C_est))]);
disp(['Multi-COLLATE Accuracy: ', num2str(dice(truth, MC_est))]);

% plot the results
a = 0.5;
figure(1);
subplot(2, 3, 1);
plot_segmentation_overlay(truth_int(:, :, 50), truth(:, :, 50), a);
title('True Segmentation');
subplot(2, 3, 2);
plot_segmentation_overlay(truth_int(:, :, 50), obs.data{1}(:, :, 50), a);
title('Example Observation');
subplot(2, 3, 3);
plot_segmentation_overlay(truth_int(:, :, 50), MV_est(:, :, 50), a);
title('Majority Vote Estimate');
subplot(2, 3, 4);
plot_segmentation_overlay(truth_int(:, :, 50), S_est(:, :, 50), a);
title('STAPLE Estimate');
subplot(2, 3, 5);
plot_segmentation_overlay(truth_int(:, :, 50), C_est(:, :, 50), a);
title('Binary COLLATE Estimate');
subplot(2, 3, 6);
plot_segmentation_overlay(truth_int(:, :, 50), MC_est(:, :, 50), a);
title('Multi-COLLATE Estimate');

