% An example spatially varying simulation. This is meant to test the STAPLE
% and Spatial STAPLE algorithms.

% simulation settings
num_raters = 15;

% set up the simulation
[obs truth] = spatial_atlas_simulation(num_raters);

% algorithm settings
epsilon = 0.001;
prior_flag = 0;
init_flag = 0;
cons_flag = 0;
interp_type = 0;
num_up = [16 10 10];
win_dims = [10 10 10];
bias = prod(obs.dims) / (num_raters * prod(win_dims));


% run the algorithms
mv_estimate = majority_vote(obs);
[STAPLE_estimate STAPLE_W STAPLE_theta] = STAPLE(obs, epsilon, ...
                                                 prior_flag, init_flag, ...
                                                 cons_flag);
[SS_estimate SS_W SS_theta] = SpatialSTAPLE(obs, epsilon, prior_flag, ...
                                            init_flag, cons_flag, ...
                                            interp_type, num_up, win_dims, ...
                                            bias);

% set the slice of interest
sl = round(obs.dims(3) /2);

% plot the results
figure(1);
subplot(2, 3, 1);
imagesc(truth(:, :, sl));
title('True Segmentation');
subplot(2, 3, 2);
imagesc(STAPLE_estimate(:, :, sl));
title('STAPLE Estimate');
subplot(2, 3, 3);
imagesc(SS_estimate(:, :, sl));
title('Spatial STAPLE Estimate');
subplot(2, 3, 4);
imagesc(mv_estimate(:, :, sl));
title('Majority Vote Estimate');
subplot(2, 3, 5);
imagesc(obs.data{1}(:, :, sl));
title('Example Observation 1');
subplot(2, 3, 6);
imagesc(obs.data{2}(:, :, sl));
title('Example Observation 2');

% print the accuracy levels to the screen
mv_accuracy = fraction_correct(truth, mv_estimate);
disp(['Majority Vote Accuracy: ', num2str(mv_accuracy)]);
STAPLE_accuracy = fraction_correct(truth, STAPLE_estimate);
disp(['STAPLE Accuracy: ', num2str(STAPLE_accuracy)]);
SS_accuracy = fraction_correct(truth, SS_estimate);
disp(['Spatial STAPLE Accuracy: ', num2str(SS_accuracy)]);

