function convert_datatype_art(in_file, out_file, varargin)
% CONVERT_DATATYPE_ART - convert a nifti file to a datatype that can be read by
%                        the ART registration algorithm.
%
% Two Forms:
% 1) convert_datatype_art(in_file, out_file)
% 2) convert_datatype_art(in_file, out_file, nochange)
%
% Input: in_file - the input filename that needs to be converted
%        out_file - the output filename
%        nochange - (optional) don't change the data range (1 or 0)
%
% Output: NONE

% whether or not to change the data range
ctype = length(varargin);

% determine whether we're doing nii of nii.gz for input file
if strcmp(in_file(end-6:end), '.nii.gz')
    typ = 1;
elseif strcmp(in_file(end-3:end), '.nii')
    typ = 0;
else
    error('Only accepts .nii and .nii.gz files');
end

% determine whether we're doing nii of nii.gz for output file
if strcmp(out_file(end-6:end), '.nii.gz')
    typ2 = 1;
elseif strcmp(out_file(end-3:end), '.nii')
    typ2 = 0;
else
    error('Only accepts .nii and .nii.gz files');
end

% read the input file
if typ == 1
    a = load_untouch_nii_gz(in_file);
else
    a = load_untouch_nii(in_file);
end

% convert the image data
a.hdr.dime.datatype = 4;
if ctype == 0
    tt = double(a.img);
    tt = int16(2^14 * (tt - min(tt(:))) / (max(tt(:)) - min(tt(:))));
    if (a.hdr.dime.scl_slope ~= 1)
        a.hdr.dime.scl_slope = 1;
    end
else
    tt = int16(a.img);
end
a.img = tt;

% save the output file
if typ2 == 1
    save_untouch_nii_gz(a, out_file);
else
    save_untouch_nii(a, out_file);
end


