function generate_braincolor_pdf(raw_fname, seg_fname, pdf_fname, tmp_dir, ...
                                 proj_name, subj_name, expr_name);
% GENERATE_BRAINCOLOR_PDF - Generates the summary PDF for whole-brain
%                           segmentation using the BrainCOLOR protocol.
%
% generate_braincolor_pdf(raw_fname, seg_fname, pdf_fname, tmp_dir)
%
% Input: raw_fname - the raw (intensity image filename -- .nii.gz)
%        seg_fname - the estimated segmentation -- .nii.gz
%        pdf_fname - the final pdf filename
%        tmp_dir - the directory to store temporary output
%        proj_name - the name of the project
%        subj_name - the name of the subject
%        expr_name = the name of the experiment
%
% Output: None.
%
% Andrew Asman via Frederick Bryan, Oct 2013

% load the figure
fig = openfig('braincolor_pdf_frame.fig','new');
fig_handles = guihandles(fig);

%
% Set all of the basic information
%
set(fig_handles.text20,'String',proj_name);
set(fig_handles.text30,'String',subj_name);
set(fig_handles.text28,'String',expr_name);
set(fig_handles.text35,'String', date);
axes(fig_handles.axes30); p=text(0,0,sprintf('Raw Image')); set(p,'rotation',90,'position',[0.5 0.5],'FontSize',12,'FontWeight','bold', 'HorizontalAlignment','center'); axis off;
axes(fig_handles.axes31); p=text(0,0,sprintf('Slicewise\nSegmentation')); set(p,'rotation',90,'position',[0.5 0.5],'FontSize',12,'FontWeight','bold', 'HorizontalAlignment','center'); axis off;
axes(fig_handles.axes32); p=text(0,0,sprintf('Cortical\nSegmentation')); set(p,'rotation',90,'position',[0.5 0.5],'FontSize',12,'FontWeight','bold', 'HorizontalAlignment','center'); axis off;
axes(fig_handles.axes33); p=text(0,0,sprintf('Mid-Brain\nSegmentation')); set(p,'rotation',90,'position',[0.5 0.5],'FontSize',12,'FontWeight','bold', 'HorizontalAlignment','center'); axis off;
set(fig_handles.text47, 'String', 'Version 1.2');

load('braincolor_cmap.mat');
raw = load_nii_gz(raw_fname);
seg = load_nii_gz(seg_fname);

% set some label information
ll = unique(seg.img);
ll = ll(2:end);
la = ones(size(ll));
la(ll >= 100) = 0;
la(ll >= 38 & ll <= 45) = 0;
la(ll >= 71 & ll <= 73) = 0;
la(ll == 35) = 0;
ll2 = ll(la > 0);

% set the default options
default_opts.fignum = 99;
default_opts.ilim = get_optimal_ilim(raw.img, seg.img);
default_opts.labels = ll;
default_opts.labelcolors = cmap_orig_vals(2:end, :);
default_opts.material = 'dull';
default_opts.slicealpha = 0.9;
default_opts.cr_buffer = -1;
default_opts.xslices = round(seg.hdr.dime.dim(2)/2)+10;
default_opts.yslices = round(seg.hdr.dime.dim(3)/2);
default_opts.zslices = round(seg.hdr.dime.dim(4)/2);

%
% Do the Slice-Based Images
%
axes(fig_handles.axes1);
plot_segmentation_overlay(permute(raw.img, [2 1 3]), ...
                          permute(seg.img, [2 1 3]), ...
                          0.0, cmap_orig_vals, default_opts.ilim, ...
                          default_opts.zslices);

axes(fig_handles.axes18);
plot_segmentation_overlay(flipdim(permute(raw.img, [3 1 2]), 1), ...
                          flipdim(permute(seg.img, [3 1 2]), 1), ...
                          0.0, cmap_orig_vals, default_opts.ilim, ...
                          default_opts.yslices);

axes(fig_handles.axes19);
plot_segmentation_overlay(flipdim(permute(raw.img, [3 2 1]), 1), ...
                          flipdim(permute(seg.img, [3 2 1]), 1), ...
                          0.0, cmap_orig_vals, default_opts.ilim, ...
                          default_opts.xslices);

axes(fig_handles.axes21);
plot_segmentation_overlay(permute(raw.img, [2 1 3]), ...
                          permute(seg.img, [2 1 3]), ...
                          0.6, cmap_orig_vals, default_opts.ilim, ...
                          default_opts.zslices);

axes(fig_handles.axes22);
plot_segmentation_overlay(flipdim(permute(raw.img, [3 1 2]), 1), ...
                          flipdim(permute(seg.img, [3 1 2]), 1), ...
                          0.6, cmap_orig_vals, default_opts.ilim, ...
                          default_opts.yslices);

axes(fig_handles.axes23);
plot_segmentation_overlay(flipdim(permute(raw.img, [3 2 1]), 1), ...
                          flipdim(permute(seg.img, [3 2 1]), 1), ...
                          0.6, cmap_orig_vals, default_opts.ilim, ...
                          default_opts.xslices);

%
% Do the Volume-Based Images
%
opts = default_opts;
opts.azimuth = 90;
opts.elevation = 90;
render_3D_labels(raw.img, seg.img, opts);
set(gcf, 'color', 'w');
set(gca, 'units', 'pixels');
fr = getframe(gcf, get(gca, 'Position'));
axes(fig_handles.axes24);
cr = determine_cropping_region(min(fr.cdata, [], 3)<255, 0);
imshow(fr.cdata(cr(1):cr(2), cr(3):cr(4), :));

opts = default_opts;
opts.azimuth = 90;
opts.elevation = 0;
render_3D_labels(raw.img, seg.img, opts);
set(gcf, 'color', 'w');
set(gca, 'units', 'pixels');
fr = getframe(gcf, get(gca, 'Position'));
axes(fig_handles.axes25);
cr = determine_cropping_region(min(fr.cdata, [], 3)<255, 0);
imshow(fr.cdata(cr(1):cr(2), cr(3):cr(4), :));

opts = default_opts;
opts.azimuth = 0;
opts.elevation = 0;
render_3D_labels(raw.img, seg.img, opts);
set(gcf, 'color', 'w');
set(gca, 'units', 'pixels');
fr = getframe(gcf, get(gca, 'Position'));
axes(fig_handles.axes26);
cr = determine_cropping_region(min(fr.cdata, [], 3)<255, 0);
imshow(fr.cdata(cr(1):cr(2), cr(3):cr(4), :));

opts = default_opts;
opts.labelalphas = la;
opts.azimuth = 90;
opts.elevation = 90;
render_3D_labels(raw.img, seg.img, opts);
set(gcf, 'color', 'w');
set(gca, 'units', 'pixels');
fr = getframe(gcf, get(gca, 'Position'));
axes(fig_handles.axes27);
cr = determine_cropping_region(min(fr.cdata, [], 3)<255, 0);
imshow(fr.cdata(cr(1):cr(2), cr(3):cr(4), :));

opts = default_opts;
opts.labelalphas = la;
opts.azimuth = 90;
opts.elevation = 0;
render_3D_labels(raw.img, seg.img, opts);
set(gcf, 'color', 'w');
set(gca, 'units', 'pixels');
fr = getframe(gcf, get(gca, 'Position'));
axes(fig_handles.axes28);
cr = determine_cropping_region(min(fr.cdata, [], 3)<255, 0);
imshow(fr.cdata(cr(1):cr(2), cr(3):cr(4), :));

opts = default_opts;
opts.labelalphas = la;
opts.azimuth = 0;
opts.elevation = 0;
render_3D_labels(raw.img, seg.img, opts);
set(gcf, 'color', 'w');
set(gca, 'units', 'pixels');
fr = getframe(gcf, get(gca, 'Position'));
axes(fig_handles.axes29);
imshow(fr.cdata);
cr = determine_cropping_region(min(fr.cdata, [], 3)<255, 0);
imshow(fr.cdata(cr(1):cr(2), cr(3):cr(4), :));

% temporarily write the result as postscript
set(fig,'PaperType','usletter', 'PaperPositionMode','auto');
temp_ps = [tmp_dir, '/temp.ps'];
print('-dpsc2','-r400', temp_ps, fig);

% conver the postscript to the file pdf file
cmmd = ['ps2pdf -dPDFSETTINGS=/prepress ' temp_ps ' ' pdf_fname];
[status,msg]=system(cmmd);
if status~=0
    fprintf('\n Could not cleanly create pdf file from ps.\n');
    disp(msg);
end

