function cmds = run_brainmask_fusion(reg_labels, fuse_file, opts)
% RUN_BRAINMASK_FUSION - run the brainmask fusion algorithm
%
% cmds = run_brainmask_fusion(reg_labels, fuse_file, opts)
%
% Input: reg_labels - the registered labels names (cell array)
%        fuse_file - the output fused file
%        opts - the options
%
% Output: cmds - the cell array of output commands

disp(sprintf('Running Brainmask Fusion: %s', fuse_file));

cmds = {};

if ~isfield(opts, 'bglabel'), opts.bglabel = 0; end

% estimate the brainmask
a = load_untouch_nii_gz(reg_labels{1});
a.img = double(a.img ~= opts.bglabel);
for i = 2:length(reg_labels)
    b = load_untouch_nii_gz(reg_labels{i});
    a.img = a.img + double(b.img ~= opts.bglabel);
end
a.img = a.img / length(reg_labels);
a.img = uint16(a.img > 0.5);
a.hdr.dime.bitpix = 16;
a.hdr.dime.datatype = 4;
a.hdr.dime.glmax = 1;
a.hdr.dime.glmin = 0;

% save the output nii file
if strcmp(fuse_file(end-3:end), '.nii')
    save_untouch_nii(a, fuse_file);
else
    save_untouch_nii_gz(a, fuse_file);
end

