function [cmds chk_files] = ...
                   run_flirt_strip_registration(target, atlas, labels, ...
                                                out_prefix, out_type, ...
                                                out_warp_dir, out_seg_dir, ...
                                                out_atlas_dir, out_temp_dir, ...
                                                regloc, opts);
% RUN_FLIRT_STRIP_REGISTRATION - runs the flirt registration algorithm between
%                          a given target and an atlas with labels
%
% [out_file done] = run_flirt_strip_registration(target, atlas, labels, ...
%                                                out_prefix, out_type, ...
%                                                out_warp_dir, out_seg_dir, ...
%                                                out_atlas_dir, ...
%                                                out_temp_dir, regloc, opts);
%
% Input: target - the target filename
%        atlas - the atlas filename
%        labels - the atlas labels filename
%        out_prefix - the output prefix for the filenames
%        out_type - the output filetype (1 - .nii, 2 - .nii.gz)
%        out_warp_dir - the output directory for the warp files
%        out_seg_dir - the output directory for the segmentation files
%        out_atlas_dir - the output directory for the registred atlas files
%        out_temp_dir - the output directory to store the temporary files
%        regloc - the location of the registration application
%        opts - the registration-specific options
%
% Output: out_file - the output segmentation file
%         done - boolean indicator whether it is done or not

% set some filenames
wrp_name = sprintf('%s/%s_affinemat.mtx', out_warp_dir, out_prefix);
if (out_type == 1)
    seg_name = sprintf('%s/%s_seg.nii', out_seg_dir, out_prefix);
    reg_name = sprintf('%s/%s.nii', out_atlas_dir, out_prefix);
else
    seg_name = sprintf('%s/%s_seg.nii.gz', out_seg_dir, out_prefix);
    reg_name = sprintf('%s/%s.nii.gz', out_atlas_dir, out_prefix);
end

chk_files{1} = wrp_name;
chk_files{2} = seg_name;
chk_files{3} = reg_name;

% set the default options
if ~isfield(opts, 'addopts')
    opts.addopts = '-usesqform -searchrx -30 30 -searchry -30 30 -searchrz -30 30 -coarsesearch 15 -finesearch 6';
end
if ~isfield(opts, 'target_strip_dir')
    error('opts.target_strip_dir must be defined');
end
if ~isfield(opts, 'atlas_strip_dir')
    error('opts.atlas_strip_dir must be defined');
end

if out_type == 1
    outstr = 'export FSLOUTPUTTYPE=NIFTI';
else
    outstr = 'export FSLOUTPUTTYPE=NIFTI_GZ';
end

cmds = {};

[a b c] = fileparts(atlas);
temp_atlas = [opts.atlas_strip_dir, b, c];
[a b c] = fileparts(target);
temp_target = [opts.target_strip_dir, b, c];

% run the flirt command
cmds{1} = sprintf('%s && %s -v %s -in %s -ref %s -omat %s\n', outstr,...
                  regloc, opts.addopts, temp_atlas, temp_target, wrp_name);

cmds{2} = sprintf(['%s && %s -v -interp nearestneighbour -in %s -ref %s ', ...
                  '-applyxfm -init %s -out %s\n'], outstr, regloc, labels, ...
                 target, wrp_name, seg_name);

cmds{3} = sprintf(['%s && %s -v -in %s -ref %s ', ...
                  '-applyxfm -init %s -out %s\n'], outstr, regloc, atlas, ...
                 target, wrp_name, reg_name);

