function [estimate] = SIMPLE(obs, num_iter_keep, alpha, varargin)
% SIMPLE - performs the SIMPLE statistical label fusion algorithm
%
% Two forms:
% 1) [estimate] = SIMPLE(obs, num_iter_keep, alpha)
% 1) [estimate] = SIMPLE(obs, num_iter_keep, alpha, performance_type)
%
% Input: obs - observation struct
%        num_iter_keep - the number of iterations to not discard any atlases
%        alpha - the constant alpha value (see paper)
%        performance_type - integer indicating the metric used to assess
%                           the iterative performance:
%                  =======> 0 -> sensitivity/specificity (default)
%                  =======> 1 -> Dice Similarity Coefficient
%                  =======> 2 -> Jaccard Index
% Output: estimate - estimate of the true segmentation
%

if length(varargin) == 0
    performance_type = 0;
else
    performance_type = varargin{1};
end

% create the java observation object
obsjava = create_java_obs(obs);

% run the constructor on the staple class (initialize)
S = edu.vanderbilt.masi.LabelFusion.SIMPLE(obsjava, num_iter_keep, ...
                                           alpha, performance_type);

% run the SIMPLE algorithm
estimate = uint8(S.run());
