function [estimate W theta] = STAPLE(obs, epsilon, prior, init_flag, cons_flag)
% STAPLE - performs the STAPLE statistical label fusion algorithm
%
% Two forms:
%1) [estimate W theta] = STAPLE(obs, epsilon, prior_flag, init_flag, cons_flag);
%2) [estimate W theta] = STAPLE(obs, epsilon, sv_prior, init_flag, cons_flag);
%
% Input: obs - observation struct
%        epsilon - the convergence factor (e.g. 0.001)
%        prior_flag - the type of prior
%                   - 0 => global prior
%                   - 1 => voxelwise prior
%        sv_prior - An explicit spatially varying prior (X x Y x Z x L)
%        init_flag - the type of initialization
%                  - 0 => W then theta
%                  - 1 => theta then W
%        cons_flag - Whether or not to ignore consensus voxels
%                  - 0 => Don't Ignore
%                  - 1 => Ignore
% Output: estimate - estimate of the true segmentation
%         W - the probability of the true segmentation for each voxel/label
%         theta - the performance level parameters
%

% create the java observation object
obsjava = create_java_obs(obs);

% run the constructor on the staple class (initialize)
S = edu.vanderbilt.masi.LabelFusion.STAPLE(obsjava, epsilon, prior, ...
                                           init_flag, cons_flag);

% run the STAPLE algorithm
estimate = uint8(S.run());
W = S.get_W();
theta = S.get_theta();
