function [estimate W theta seed_points] = ...
                              SpatialSTAPLE(obs, epsilon, prior, ...
                                        init_flag, cons_flag, interp_type, ...
                                        num_up, win_dims, bias, varargin)
% SpatialSTAPLE - performs the SpatialSTAPLE statistical label fusion algorithm
%
% Five forms:
% 1) [estimate W theta] = SpatialSTAPLE(obs, epsilon, prior_flag, init_flag, ...
%                                       cons_flag, interp_type, num_up, ...
%                                       win_dims, bias, bias_theta);
% 2) [estimate W theta] = SpatialSTAPLE(obs, epsilon, sv_prior, init_flag, ...
%                                       cons_flag, interp_type, num_up, ...
%                                       win_dims, bias, bias_theta);
% 3) [estimate W theta] = SpatialSTAPLE(obs, epsilon, prior_flag, init_flag, ...
%                                       cons_flag, interp_type, num_up, ...
%                                       win_dims, bias);
% 4) [estimate W theta] = SpatialSTAPLE(obs, epsilon, sv_prior, init_flag, ...
%                                       cons_flag, interp_type, num_up, ...
%                                       win_dims, bias);
% 5) [estimate W theta seed_points] = SpatialSTAPLE(....)
%
% Input: obs - observation struct
%        epsilon - the convergence factor (i.e. 0.001)
%        prior_flag - the type of prior
%                   - 0 => global prior
%                   - 1 => voxelwise prior
%        sv_prior - An explicit spatially varying prior (X x Y x Z x L)
%        init_flag - the type of initialization
%                  - 0 => W then theta
%                  - 1 => theta then W
%        cons_flag - the type of consensus-based analysis
%                  - 0 => don't ignore consensus
%                  - 1 => ignore consensus
%                  - 2 => ignore consensus based upon the prior (thread = 0.95)
%        interp_type - the type of interpolation
%                    - 0 => Nearest Neighbor
%                    - 1 => Linear
%        num_up - 3 element array specifying number of theta updates
%                 in x, y, and z directions
%        win_dims - the dimensions of the windows [x y z]
%        bias - the bias applied to the biasing theta
%        bias_theta - (optional) biasing performance level parameters
%                     NOTE: if not specified, the theta from majority vote
%                           ignoring consensus voxels is used.
% Output: estimate - estimate of the true segmentation
%         W - the probability of the true segmentation for each voxel/label
%         theta - the performance level parameters
%         seed_points - the seed points for the corresponding performance
%                       level parameters
%

% create the java observation object
obsjava = create_java_obs(obs);

% run the constructor on the Spatial STAPLE class (initialize)
if length(varargin) == 0
    ss = edu.vanderbilt.masi.LabelFusion.SpatialSTAPLE(obsjava, epsilon, ...
                                                    prior, init_flag, ...
                                                    cons_flag, interp_type, ...
                                                    num_up, win_dims, bias);
else
    ss = edu.vanderbilt.masi.LabelFusion.SpatialSTAPLE(obsjava, epsilon, ...
                                                    prior, init_flag, ...
                                                    cons_flag, interp_type, ...
                                                    num_up, win_dims, ...
                                                    bias, varargin{1});
end


% run the Spatial STAPLE algorithm
estimate = uint8(ss.run());
W = ss.get_W();
theta = ss.get_theta();
seed_points = ss.get_seed_points();
