function brain_detection(in_fname, MNI_fname, out_dir, out_res, ...
                         interp_type, num_bins, lperc, hperc, thresh)


tic;
tprintf('\n');
tprintf('*** Running Automated Brain Detection ***\n');
tprintf('\n');
tprintf('============== Settings ================\n');
tprintf('Input Volume: %s\n', in_fname);
tprintf('MNI Filename: %s\n', MNI_fname);
tprintf('Temporary Output Directory: %s\n', out_dir);
tprintf('Output Resolution: [%f %f %f]\n', out_res(1), out_res(2), out_res(3));
tprintf('Interpolation Type: %s\n', interp_type);
tprintf('Mutual Information Settings: %d, %f, %f\n', num_bins, lperc, hperc);
tprintf('Mutual Information Threshold: %f\n', thresh);
tprintf('========================================\n');
tprintf('\n');

% set the filenames
bname = get_basename(in_fname);
resample_MNI_fname = [out_dir, 'resample_MNI.nii.gz'];
resample_fname = [out_dir, 'resample_target.nii.gz'];
reg_fname = [out_dir, 'resample_target_reg.nii.gz'];
mtx_fname = [out_dir, 'resample_target_reg.mtx'];
valid_fname = [out_dir, 'resample_target_is_brain'];

tprintf('Resampling the MNI Volume\n');
resample_nii(MNI_fname, resample_MNI_fname, out_res, interp_type);
tprintf('Resampling the Volume\n');
resample_nii(in_fname, resample_fname, out_res, interp_type);

a = load_nii_gz(resample_fname);
if length(size(squeeze(a.img))) == 2
	tprintf('Setting MI to 0 in this if\n');
	mi = 0;
else

	% run the registration
	tprintf('Running the registration\n');
	cmd{1} = sprintf('/share/bin/fsl-64/bin/flirt -in %s -ref %s -out %s \n', ...
		              resample_fname, resample_MNI_fname, reg_fname);
	tprintf('This is the nifty_reg command: %s\n',cmd{1})
	run_cmd_single(cmd);

	tprintf('Calculating Mutual Information\n');
	try

	    % calculate the mutual information
		a = load_nii_gz(resample_MNI_fname);
		b = load_nii_gz(reg_fname);
		mi = mutualinfo(a.img, b.img, num_bins, lperc, hperc);


    catch err
		tprintf('Setting MI to zero in catch block\n');
	    mi = 0;
	end
end
tprintf('Mutual Information: %f\n', mi);

% set whether or not it is a brain
if (mi > thresh)
    isbrain = 'yes';
elseif (mi > (thresh-0.15))
	isbrain = 'maybe';
else
    isbrain = 'no';
end
tprintf('Is a brain?: %s\n', isbrain);
