function obs_frac = get_fraction_obs(obs, frac)
% GET_FRACTION_OBS - Returns a random fraction of the observations
%                    useful for monte carlo testing
%
% obs_frac = get_fraction_obs(obs, frac);
%
% Input: obs - the full observation struct (slice-type)
%        frac - fraction of the observations to keep
%
% Output: obs_frac - the smaller observation set

num_keep = round(obs.num_obs * frac);

rp = randperm(obs.num_obs);
rp = rp(1:num_keep);

obs_frac = obs;
obs_frac.data = obs_frac.data(rp);
obs_frac.raters = obs_frac.raters(rp);
obs_frac.slices = obs_frac.slices(rp);
obs_frac.num_obs = num_keep;
