function weights = get_intensity_weights(targetim, ims, sigma)
% GET_INTENSITY_WEIGHTS - returns the weights based on an intensity type
%                         approach for a series of raters.
%
% weights = get_intensity_weights(targetim, ims, sigma)
%
% Input:  targetim - the target image
%         ims - the intensity images. The size(ims) = [X Y Z R], where
%               X, Y, and Z are the length of the respective dimensions and
%               R is the number of raters
%         sigma - the standard deviation of the assumed gaussian
% Output: weights - the weights associated with each rater at each voxel.
%                   size(weights) = [X Y Z R];
%                   Note: sum(weights(x, y, z, :)) = 1 for all voxels
%
% Note: the intensity images should be normalized before using this function
%       see 'help normalize_intensity'

dims = size(targetim);
num_raters = size(ims, 4);

targetim = double(targetim);
ims = double(ims);

pf = 1 / sqrt(2 * pi * sigma^2);
ef = - 1 / (2 * sigma^2);

% set the weights
for i = 1:num_raters
    im = ims(:, :, :, i);
    weights(:, :, :, i) = pf * exp(ef * (targetim - im).^2);
end
weights = weights ./ repmat(sum(weights, 4), [1 1 1 num_raters]);
weights(isnan(weights)) = 1/num_raters;

