function obs_cov = get_random_coverages(obs, c)
% GET_RANDOM_COVERAGES - returns a random collection of observations to
%                        form "c" full coverages. In situations where the
%                        desired number of observations is not available
%                        for a given slice, all observations of that slice
%                        are provided.
%
% Input: obs - the full observation set
%        c - the number of coverages
%
% Output: obs_cov - the c-coverage observation set

% make sure it is slice type
if strcmp(obs.type, 'slice')

    % initialize the coverage observations
    obs_cov = create_obs(obs.type, obs.dims);

    % iterate over each slice
    for s = 1:obs_cov.dims(3)

        % find all the indices that represent an observation of this slice
        inds = find(obs.slices == s);

        if length(inds) > c
            rp = randperm(length(inds));
            sinds = inds(rp(1:c));
        else
            sinds = inds;
        end

        for i = 1:length(sinds)
            obs_cov = add_obs(obs_cov, obs.data{sinds(i)}, ...
                              obs.slices(sinds(i)), obs.raters(sinds(i)));
        end
    end
elseif strcmp(obs.type, 'volume')

    % initialize the coverage observations
    obs_cov = create_obs(obs.type, obs.dims);

    if obs.num_obs <= c
        obs_cov = obs;
    else
        rp = randperm(obs.num_obs);
        list = rp(1:c);
        for i = 1:c
            obs_cov = add_obs(obs_cov, obs.data{list(i)});
        end
    end
else
    error('Invalid observation type');
end

