function theta = get_theta_from_W(obs, W)

unique_labels = [];
for r = 1:obs.num_obs
    unique_labels = union(unique_labels, unique(obs.data{r}));
end
num_labels = length(unique_labels);

theta = zeros(num_labels, num_labels, obs.num_obs);

for r = 1:obs.num_obs
    r
    for l1 = 1:num_labels
        for l2 = 1:num_labels
            wl = W(:, :, :, l2);
            wl(wl == 1) = 0;
            wls = sum(wl(obs.data{r}==l1-1));
            theta(l1, l2, r) = theta(l1, l2, r) + wls;
        end
    end
end

for r = 1:obs.num_obs
    for l = 1:num_labels
        st = sum(theta(:, l, r));
        if (st > 0)
            theta(:, l, r) = theta(:, l, r) / st;
        else
            theta(:, l, r) = 0;
            theta(l, l, r) = 1;
        end
    end
end


