function varargout = featurebox_nobuttons(varargin)
% FEATUREBOX_NOBUTTONS MATLAB code for featurebox_nobuttons.fig
%      FEATUREBOX_NOBUTTONS, by itself, creates a new FEATUREBOX_NOBUTTONS or raises the existing
%      singleton*.
%
%      H = FEATUREBOX_NOBUTTONS returns the handle to a new FEATUREBOX_NOBUTTONS or the handle to
%      the existing singleton*.
%
%      FEATUREBOX_NOBUTTONS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FEATUREBOX_NOBUTTONS.M with the given input arguments.
%
%      FEATUREBOX_NOBUTTONS('Property','Value',...) creates a new FEATUREBOX_NOBUTTONS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before featurebox_nobuttons_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to featurebox_nobuttons_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help featurebox_nobuttons

% Last Modified by GUIDE v2.5 05-Aug-2013 16:38:51

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @featurebox_nobuttons_OpeningFcn, ...
    'gui_OutputFcn',  @featurebox_nobuttons_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% KEY I/O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- Executes just before featurebox_nobuttons is made visible.
function featurebox_nobuttons_OpeningFcn(hObject, ~, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to featurebox_nobuttons (see VARARGIN)

% figure out if there was a previous struct
if nargin > 3
    feat_struct = varargin{1}; % get it
else
    feat_struct = []; % initialized
end

% parse text file for list of feature files
% this thing is to be parsed from the AUTO text file
% each line is:
% feature_tag,default(a string),optional_string_for_name
feature_list = parse_feature_file;

% Standard info/parameters for creation of checkboxes
FT = 'Helvetica';
FTSZ = 9;
FTUN = 'points';
fnt_info = {FT,FTSZ,FTUN};

UNITS = 'characters';

CLBK = @(hObject,eventdata)featurebox_nobuttons('general_checkBox_callback',...
    hObject,eventdata,guidata(hObject));

% sizes of text boxes
% [left bottom width height]
LFT = 1.5;
MID = 45;
TOP1 = 5.25; % relative to bottom of panel 1
TOP2 = 13.25; % relative to bottom of panel 2
TOP3 = 5.25; % relative to bottom of panel 3
BTWN = 1.75;
WTH = 45;
HGT = 1.92;

% preprocessing
num_row = 4; 
max_buttons = 8; 
boxdims = [LFT MID TOP1 BTWN WTH HGT];
current_num_boxes = 0;
uipanelhandle = handles.uipanel1;
[handles,numboxes] = ...
    new_box_fn(handles,uipanelhandle,feature_list.preprocessing,...
    feat_struct,...
    boxdims,[num_row, max_buttons], current_num_boxes,...
    fnt_info,UNITS,CLBK);

% features
num_row = 10; 
max_buttons = 20; 
boxdims = [LFT MID TOP2 BTWN WTH HGT];
current_num_boxes = numboxes;
uipanelhandle = handles.uipanel2;
[handles,numboxes] = ...
    new_box_fn(handles,uipanelhandle,feature_list.features,...
    feat_struct,...
    boxdims,[num_row, max_buttons], current_num_boxes,...
    fnt_info,UNITS,CLBK);

% postprocessing 
num_row = 4; 
max_buttons = 8; 
boxdims = [LFT MID TOP3 BTWN WTH HGT];
current_num_boxes = numboxes;
uipanelhandle = handles.uipanel3;
[handles,~] = ...
    new_box_fn(handles,uipanelhandle,feature_list.postprocessing,...
    feat_struct,...
    boxdims,[num_row, max_buttons], current_num_boxes,...
    fnt_info,UNITS,CLBK);


% last initializations
handles.feat_struct.cancelled = 1; % default true

% Choose default command line output for featurebox_nobuttons
handles.output = handles.feat_struct;

% Update handles structure
guidata(hObject, handles);


% UIWAIT makes featurebox_nobuttons wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = featurebox_nobuttons_OutputFcn(~, ~, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;
close(handles.figure1);

function cancel_Callback(hObject, ~, handles)
% --- Executes on button press in cancel.
handles.feat_struct.cancelled = 1;
handles.output = handles.feat_struct;
guidata(hObject,handles);
uiresume(handles.figure1); % will call OutputFcn

function go_Callback(hObject, ~, handles)
% hObject    handle to go (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.feat_struct.cancelled = 0; 
handles.output = handles.feat_struct;
guidata(hObject,handles);
uiresume(handles.figure1);

function automode_Callback(hObject, ~, handles)
% hObject    handle to automode (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of automode
if get(hObject,'Value');
        
    % grey out config drop down
    set(handles.configpopup,'Enable','off');
    
    % grey out and change state of buttons
    % get handles to buttons
    f = fields(handles);
    tmp = find(strncmp('checkbox',f,5)); % indicies for handles
    for i =1:length(tmp);

        % figure out the name of this bad boy
        tag = get(handles.(f{tmp(i)}),'tag');

        % figure out default
        def = handles.feat_struct.(tag).default;
        
        % store current "status" in "hist", change to def status
        handles.feat_struct.(tag).hist = handles.feat_struct.(tag).status;
        handles.feat_struct.(tag).status = def;
        
%       guidata(hObject, handles);

        % grey out and change value to defaults
        set(handles.(f{tmp(i)}),'Enable','off','Value',def);
    end
    
else % just tured off auto mode
        
    % ungrey and restore state of buttons
    % get handles to buttons
    f = fields(handles);
    tmp = find(strncmp('checkbox',f,5)); % logical array for handles
    for i =1:length(tmp);

        % figure out the name of this bad boy
        tag = get(handles.(f{tmp(i)}),'tag');

        % figure out previous status (.hist)
        def = handles.feat_struct.(tag).hist;

        % change to hist status
        handles.feat_struct.(tag).status = def;
%       guidata(hObject, handles);


        % ungrey out and change value to status
        set(handles.(f{tmp(i)}),'Enable','on','Value',def);
    end
    
    % ungrey config drop down
    set(handles.configpopup,'Enable','on');
    
    
end

% save handles
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function configpopup_CreateFcn(hObject, ~, handles)
% hObject    handle to configpopup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), ...
        get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% config files are in the same place
[path,~,~] = fileparts(which('FEATURES.txt'));
config_files = struct2cell(dir([path filesep '*.txt']));
config_files =config_files(1,:); % just top row

% dont want FEATURES.txt again
config_files = config_files(~strcmp(config_files,'FEATURES.txt'));

% generate string for popup box
options = '-';


for ii=1:length(config_files);
    options = [options '|' config_files{ii}(1:end-4)]; % drop '.txt'
end

% populate box
set(hObject,'String',options);

set(hObject,'Value',1);



% --- Executes on selection change in configpopup.
function configpopup_Callback(hObject, ~, handles)
% hObject    handle to configpopup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%
% Hints: contents = cellstr(get(hObject,'String')) returns configpopup contents as cell array
%        contents{get(hObject,'Value')} returns selected item from configpopup

% name of file chosen
contents = cellstr(get(hObject,'String'));
file = contents{get(hObject,'Value')};

% parse textfile to produce cell array
features = parse_config_file([file '.txt']);

% go through each checkbox. 
f = fields(handles);
tmp = find(strncmp('checkbox',f,5)); % logical array for handles
for i =1:length(tmp);

    % figure out the name of this bad boy
    tag = get(handles.(f{tmp(i)}),'tag');

    % Save history.
    handles.feat_struct.(tag).hist = handles.feat_struct.(tag).status;
    
    % Set if found in features cell array. 
    if any(strcmp(tag,features));
        handles.feat_struct.(tag).status = 1;
        set(handles.(f{tmp(i)}),'Value',1); %f{tmp(i)} is the actuall tag string
        
        % If found remove item from cell array.
        features = features(~strcmp(tag,features));
    else
        % Unset if not.
        handles.feat_struct.(tag).status = 0;
        set(handles.(f{tmp(i)}),'Value',0);
    end

end

% save
guidata(hObject,handles);

% check if features cell array empty
if ~isempty(features)
    fprintf('The following strings parsed from %s had no match:\n',file);
    for ii = 1:length(features);
        disp(features{ii});
    end
end

%%%%%%%%%%%%%% UTILS  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


function general_checkBox_callback(hObject,~,handles)
% call back to call this function
% featurebox_nobuttons('general_checkBox_callback',...
%     hObject,eventdata,guidata(hObject))
TAG = get(hObject,'Tag'); % TAG = name of feature (e.g. 'normalize')

if isfield(handles.feat_struct,TAG)
    if get(hObject,'Value')
        handles.feat_struct.(TAG).status = 1;
    else
        handles.feat_struct.(TAG).status = 0 ;   
    end
    guidata(hObject,handles); % update data structure
else
    warning('feature clicked on not recognized as struct fieldname...hmm')
end


function [handles,it] = ...
    new_box_fn(handles,pan_handle,infostct, feat_struct, boxdims, butdims,...
    sit,fnt_info,UNITS,CLBK)
% INPUTS
% handles is the handles struct from main
% pan_handle is the handle to the panel in which these buttons 
%   should be children 
% infostct had fields: tag, defaults, and name
%   it's a substruct from the struct that came from parsing the text file
% featstct is the feature struct that this function outputs
%   This could be empty or it could be populated from last time.
% boxdims = [lft, mid, top, btwn, wth, hgh]
% but dims is [buttons in col1, max buttons (2x row1 unless something special)
% sit is starting iterator value (coutns number of checkboxes created)
% fnt info: Font info {FT,FTSZ,FTUN}
% UNITS  (e.g. 'characters')
% CLBK = call back fun (e.g. @(some_callback_fun) )
%
% OUTPUTS
% handles is the handles gui object, now modified
% it is the total cnt of checkboxes now in existence (it = sit + num_loops)
%
% Sample call:
% [handles,numboxes] = ...
%     new_box_fn(handles,handles.panel1,feature_list.preprocessing,feat_struct,
%     boxdims,button_info, current_num_boxes,...
%     fnt_info,UNITS,CLBK);

% parse info from input args
LFT = boxdims(1);
MID = boxdims(2);
TOP = boxdims(3); % relative to bottom of panel 
BTWN = boxdims(4);
WTH = boxdims(5);
HGT = boxdims(6);

num_rows = butdims(1);
max_butts = butdims(2);

FT = fnt_info{1};
FTSZ = fnt_info{2};
FTUN = fnt_info{3};

% count number of features for iteration
it = sit;

for i=1:length(infostct.tag)
        
    % create uicontrol in first box
    TAG = infostct.tag{i};
    DEFAULT = str2double(infostct.defaults{i});
    if ~isempty(infostct.name{i})
        STR = infostct.name{i};
    else
        STR = infostct.tag{i};
    end
    
    % add to handles.feat_struct 
    % add status depending on if empty or not
    if ~isfield(feat_struct,TAG)
        % add tag to feature struct
        handles.feat_struct.(TAG).status=0;
    else
        handles.feat_struct.(TAG).status = feat_struct.(TAG).status;
    end
    % add default  (which stayed the same, so is the same in both cases)
    handles.feat_struct.(TAG).default=DEFAULT;
    
    % whether it should start checked or unchecked
    value = handles.feat_struct.(TAG).status; 
    
    if i<=num_rows  % can fit so many (e.g. 4) buttons
        h = uicontrol(pan_handle,'Style','checkbox',...
            'Units',UNITS, 'Position',[LFT TOP-BTWN*(i-1) WTH HGT], ...
            'String',STR, 'Tag',TAG,...
            'FontName',FT,'FontSize',FTSZ,'FontUnits',FTUN,...
            'Callback',CLBK, ...
            'Value',value);
        it=it+1;
    elseif i<=max_butts % total num butons allowed (usally 2x num_rows)
        h = uicontrol(pan_handle,'Style','checkbox',...
            'Units',UNITS, 'Position',[MID TOP-BTWN*(i-1-4) WTH HGT], ...
            'String',STR, 'Tag',TAG,...
            'FontName',FT,'FontSize',FTSZ,'FontUnits',FTUN,...
            'Callback',CLBK, ...
            'Value',value);
        it=it+1;
    else
        warning('too many preprocessing options, not all shown')
    end
    
    % add handle to handles struct
    handles.(['checkbox' num2str(it)])=h;

end


function feature_list = parse_feature_file

if ~exist('FEATURES.txt','file');
    error('FEATURES text file not on path');
end

fid = fopen('FEATURES.txt');
txt = strtrim(textscan(fid, '%s %s %q','Delimiter',','));
fclose(fid);

if numel(txt{1})<5 || ~isequal(size(txt{1}),size(txt{2}),size(txt{3})) 
    % minumum of 5 lines!(version, pre,feat,post,notes)
    % 
    error('Error in parsing FEATURES list');
end

version = str2double( txt{1}{1}(3:end) ); % currently unused

preloc = find(strcmp(txt{1},'#PREPROCESSING'));
floc = find(strcmp(txt{1},'#FEATURE'));
postloc = find(strcmp(txt{1},'#POSTPROCESSING'));
noteloc = find(strcmp(txt{1},'#NOTES'));

% preprocessing
cnt = 1;
for i = (preloc+1):(floc-1)
    feature_list.preprocessing.tag{cnt} = txt{1}{i};
    feature_list.preprocessing.defaults{cnt} = txt{2}{i};
    feature_list.preprocessing.name{cnt} = txt{3}{i};
    cnt = cnt+1;
end
% feature
cnt = 1;
for i = (floc+1):(postloc-1)
    feature_list.features.tag{cnt} = txt{1}{i};
    feature_list.features.defaults{cnt} = txt{2}{i};
    feature_list.features.name{cnt} = txt{3}{i};
    cnt = cnt+1;
end
% preprocessing
cnt = 1;
for i = (postloc+1):(noteloc-1)
    feature_list.postprocessing.tag{cnt} = txt{1}{i};
    feature_list.postprocessing.defaults{cnt} = txt{2}{i};
    feature_list.postprocessing.name{cnt} = txt{3}{i};
    cnt = cnt+1;
end


function cellarr = parse_config_file(file)

fid = fopen(file);
txt = strtrim(textscan(fid, '%s ','Delimiter',','));
fclose(fid);

if numel(txt{1})<2 
    % minumum of 2 lines!(version, notes)
    error('Error in parsing config file');
end

version = str2double( txt{1}{1}(3:end) ); % currently unused

noteloc = find(strcmp(txt{1},'#NOTES'));

cellarr = txt{1}(2:noteloc-1);






