function varargout = labelbox(varargin)
% LABELBOX MATLAB code for labelbox.fig
%      LABELBOX, by itself, creates a new LABELBOX or raises the existing
%      singleton*.
%
%      H = LABELBOX returns the handle to a new LABELBOX or the handle to
%      the existing singleton*.
%
%      LABELBOX('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in LABELBOX.M with the given input arguments.
%
%      LABELBOX('Property','Value',...) creates a new LABELBOX or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before labelbox_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to labelbox_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help labelbox

% Last Modified by GUIDE v2.5 09-Aug-2013 12:04:13

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @labelbox_OpeningFcn, ...
    'gui_OutputFcn',  @labelbox_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


%%% KEY I/O FUNCTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% --- Executes just before labelbox is made visible.
function labelbox_OpeningFcn(hObject, ~, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to labelbox (see VARARGIN)

% change what clicking "x" does.
% it now calls the imdone_Callback function
set(handles.figure1,'CloseRequestFcn',@(hObject,eventdata)labelbox(...
    'xbutton_Callback',hObject,eventdata,guidata(hObject)))

% change window name from "labelbox"
set(handles.figure1,'Name','Quick Label v1');

% get data from command line and put in handles structure
% this if statement only occurs if you call labelbox w/ no args.
if isempty(varargin); % for testing
    varargin{1} = rand(100,100,5);
    varargin{2} = [1 1 1];
    
    % demo images from /usr/local/MATLAB/R2012a/toolbox/images/imdemos/
    tmp = img_normalize(double(imread('cameraman.tif')));
    [x y] = ndgrid(linspace(1,100,size(tmp,1)), linspace(1,100,size(tmp,2))); 
    [xi yi] = ndgrid(1:100);
    varargin{1}(:,:,1) = interpn(x,y,tmp,xi,yi);
    
    tmp = img_normalize(double(imread('pout.tif')));
    [x y] = ndgrid(linspace(1,100,size(tmp,1)), linspace(1,100,size(tmp,2))); 
    [xi yi] = ndgrid(1:100);
    varargin{1}(:,:,2) = interpn(x,y,tmp,xi,yi);
    
    tmp = img_normalize(double(imread('tire.tif')));
    [x y] = ndgrid(linspace(1,100,size(tmp,1)), linspace(1,100,size(tmp,2))); 
    [xi yi] = ndgrid(1:100);
    varargin{1}(:,:,4) = interpn(x,y,tmp,xi,yi);
    
    tmp = img_normalize(double(imread('spine.tif')));
    [x y] = ndgrid(linspace(1,100,size(tmp,1)), linspace(1,100,size(tmp,2))); 
    [xi yi] = ndgrid(1:100);
    varargin{1}(:,:,5) = interpn(x,y,tmp,xi,yi);
    
    disp('labelbox called with no args. dummy.')
end

% pixdim default
if nargin < 2;
    varargin{2} = [1 1 1]; 
end

handles.im = varargin{1};
handles.mid = ceil(size(handles.im,3)/2);
handles.top = size(handles.im,3);
handles.pixdim = varargin{2};
handles.ax_pixdim = handles.pixdim.^-1;
handles.currsl = handles.mid;

% Choose default command line output for labelbox
handles.mask = false(size(handles.im));
handles.rgb = zeros([size(handles.im) 3]);
handles.rgbvalid = false(size(handles.im,3),1);

% plot stuff
handles = replotim(handles);

% fix slider increment
step = [1, 1] / (handles.top - 1);
set(handles.slider1,'Min',1,'Max',handles.top,'SliderStep',step,...
    'Value',handles.currsl);

% make done flag
handles.done = 1;

% Update handles structure
guidata(hObject, handles);

% keeps figure open until gui_imdone clicked
waitfor(handles.figure1,'Visible');
% UIWAIT makes labelbox wait for user response (see UIRESUME)
% uiwait(handles.figure1)

% --- Outputs from this function are returned to the command line.
function varargout = labelbox_OutputFcn(~, ~, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
if nargout == 0
    disp('nargout = 0');
    if isfield(handles,'timespent')
        tps = sum(handles.timespent);
    else
        tps = 0;
    end
    varargout{1} = 'empty';
    disp('GUI closed. Returned ''empty''');
end
    
if nargout>0
    if isempty(handles); varargout{1} = 'empty';
        disp('GUI closed. Returned ''empty''');
    else varargout{1} = handles.mask;
        disp('Mask passed from GUI');
    end
end

if nargout > 1; 
    varargout{2} = handles; % pass all info to function call
end

fprintf('Total time spent processing: %5.2fs (%02d:%02d:%02d) \n',...
    tps,floor(tps/3600),floor(mod(tps,3600)/60), floor(mod(tps,60)));

closereq;

function gui_imdone_Callback(~, ~, handles) %#ok<*DEFNU>
% hObject    handle to gui_imdone (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
disp('imdone pressed')
if ~isequal(zeros(size(handles.mask)),handles.mask)
    g = questdlg('You have entered data on the mask. Ready to close?',...
        'Close','YES','NO','NO');
    if strcmp(g,'YES')
        set(handles.figure1,'Visible','off') % activates labelbox_OutputFcn
    else
        %nothing
    end
else
    set(handles.figure1,'Visible','off'); % activates labelbox_OutputFcn
end

function xbutton_Callback(~, ~, ~)
% hObject    handle to gui_imdone (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

closereq;



%%% LABELLING FUNCTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function gui_labelme_Callback(hObject, ~, handles)
% hObject    handle to gui_labelme (see GCBO)h
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if strcmp(get(handles.gui_labelme,'Enable'),'off')
    disp('tried to enter labelmode at a bad time')
    keyboard;
end

changetxt(handles.mssgbox,'IN LABEL MODE');

% deactivate all buttons
grey_on_off(handles,'grey');

% create impoly object
if get(handles.gui_polymode,'Value');
    h = impoly(handles.axes1);
elseif get(handles.gui_freehandmode,'Value');
    h = imfreehand(handles.axes1);
else
    disp('neither polymode nor freehand selected');
end

% wait till double clikc to proceed
wait(h);

try % the regular path
    mask = createMask(h);

    % add (OR) or subtractice (AND NOT mask) modes
    if get(handles.gui_additivemode,'Value');
        handles.mask(:,:,handles.currsl) = ...
            handles.mask(:,:,handles.currsl) | mask;
    elseif get(handles.gui_subtractivemode, 'Value')
        handles.mask(:,:,handles.currsl) = ...
            handles.mask(:,:,handles.currsl) & ~mask;
    else
        error('check additive/subtractive mode handles in labelbox');
    end

    delete(h)

    % print success on completion
    changetxt(handles.mssgbox,'Mask Accepted!');
    
catch 
    warning('createMaskErr','CreateMask threw error (caught)');
    changetxt(handles.mssgbox,'Mask Error\nMask Discarded!');
end

% reactivate all buttons
grey_on_off(handles,'ungrey');

% draw ROI
handles.rgbvalid(handles.currsl) = false;
handles = replotim(handles);

% update handles (mask updated)
guidata(hObject,handles)

function gui_clearslice_Callback(hObject, ~, handles)
% hObject    handle to gui_clearslice (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.mask(:,:,handles.currsl) = zeros;
changetxt(handles.mssgbox,'CLEARED MASK FOR SLICE!');
handles.rgbvalid(handles.currsl)=false;
handles = replotim(handles);
guidata(hObject, handles)

function gui_fillin_Callback(hObject, ~, handles)
% hObject    handle to gui_fillin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if ismatrix(handles.mask);
    changetxt(handles.mssgbox,'Makes no sense in 2D context');
    return;
end


have_data = find(squeeze(sum(sum(handles.mask,1),2)));
if length(have_data)>1
    for ii = 1:length(have_data)-1; % more than one slize
        if have_data(ii)<have_data(ii+1)-1; % more than one slice away
            bottom = handles.mask(:,:,have_data(ii));
            top = handles.mask(:,:,have_data(ii+1));
            need = have_data(ii+1)-(have_data(ii))-1; % # new slices needed

%             handles.mask(:,:,have_data(ii)+1:have_data(ii+1)-1) = ...
%                 repmat(top & bottom,[1 1 need]);
            handles.mask(:,:,have_data(ii)+1:have_data(ii+1)-1) = ...
                interp_shape(top,bottom,need);
            
        end
    end
    grey_on_off(handles,'grey');
    handles = replotim(handles,1);
    grey_on_off(handles,'ungrey');
    guidata(hObject, handles);
    changetxt(handles.mssgbox,'Filled inbetween labeled slices');
else
    changetxt(handles.mssgbox, 'Empty Mask or Only 1 slice, Cannot Fill');
end


%%% MATH HEAVY FUNCTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function gui_logisticizeme_Callback(hObject, ~, handles)
% hObject    handle to gui_logisticizeme (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% call the little box to select features from possible options
if ~isfield(handles, 'feature_struct');
    handles.feature_struct = featurebox_nobuttons;
else
    handles.feature_struct = featurebox_nobuttons(handles.feature_struct);
end
% feauture struct is of the form
% feature_struct.(tag).status = 1/0
% feature_struct.(tag).default = 1/0

% update before calling the quick classify
% function that can take a while
guidata(hObject, handles);

if handles.feature_struct.cancelled == 0;
    
    if any(handles.mask(:)); % check if not empty
        
        % save mask (if modified in previous iteration)
        % archive new mask and 1st mask if 1st time run (as logical) 
        if ~isfield(handles,'nummasks') 
            % the first time logisticize is run
            handles.nummasks = 1;
            if ~isa(handles.mask, 'logical');
                handles.all_masks{1} = logical(handles.mask);
            else
                handles.all_masks{1} = handles.mask;
            end
            
            set(handles.gui_maskarchivebox,'String','orig');
        end 
           
        fprintf('\nClassification going!\n');
        if isfield(handles,'orig_im')
            im = handles.orig_im;
        else
            im = handles.im;
        end
        
        % take control
        grey_on_off(handles,'grey')

        try % good change this will error
            [mask_est,ts] = quickclassify(im,handles.mask,handles.pixdim,...
                handles.feature_struct);
            
            % return control 
            grey_on_off(handles,'ungrey')
        catch err
            % cathc error just so taht we can ungrey before throwing
            
            % return control 
            disp('some error in quickclassify');
            grey_on_off(handles,'ungrey')
            
            rethrow(err);
        end

        
        % first time gui updates
        if handles.nummasks == 1;
            set(handles.gui_maskarchivebox,'Visible','on');
            set(handles.archivetext,'Visible','on');
        end
        
        % incrememnnt total number of masks
        handles.nummasks = handles.nummasks+1;
        
        % save new mask and timespent info
        if ~isa(mask_est,'logical');
            handles.all_masks{handles.nummasks} = logical(mask_est);
        else
            handles.all_masks{handles.nummasks} = mask_est;
        end
        handles.timespent(handles.nummasks) = ts;
                
        % update GUI
        handles.currmask = handles.nummasks; % update to the one we just go
        handles.mask = handles.all_masks{handles.currmask};

        % fix the archive gui
        keyboard;
        ma = get(handles.gui_maskarchivebox,'String'); % get current string mat
        str = num2str(handles.nummasks); 
        while length(str)<size(ma,2); str = [str ' ']; end % put str inot str mat
        set(handles.gui_maskarchivebox,'String',[ma ; str ]);
        set(handles.gui_maskarchivebox,'Value',handles.currmask);
        
        % replot 
        handles.rgbvalid = false(size(handles.rgbvalid));
        handles.rgb = zeros(size(handles.rgb)); 
        handles = replotim(handles,1);
        changetxt(handles.mssgbox,'Mask Estimate Loaded.');
        
        % save
        guidata(hObject, handles);
        
    else
        fprintf('\nMask Empty. Not classifying\n');
        
    end
else
    % don't call quickclassify, just do nothing
    fprintf('\nClassification cancelled.\n');
end


%%% UI FUNCTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function gui_sliceup_Callback(hObject, ~, handles)
% hObject    handle to gui_sliceup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if handles.currsl<handles.top
    % increment, redraw & update
    handles.currsl = handles.currsl+1;
    handles = replotim(handles);
    changetxt(handles.mssgbox,'');
    guidata(hObject, handles);
else
    fprintf('\nTOP OF IMAGE. NO MORE UPPY FOR YOU!');
end

function gui_slicedown_Callback(hObject, ~, handles)
% hObject    handle to gui_slicedown (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if handles.currsl>1
    % redraw & increment & update
    handles.currsl = handles.currsl-1;
    handles = replotim(handles);
    changetxt(handles.mssgbox,'');
    guidata(hObject, handles);
else
    fprintf('\nBOTTOM OF IMAGE. NO MORE DOWNY FOR YOU!');
end

function slider1_Callback(hObject, ~, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.currsl = round(get(handles.slider1,'Value'));
handles = replotim(handles);
changetxt(handles.mssgbox,'');
guidata(hObject, handles);

function slider1_CreateFcn(hObject, ~, ~)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

function gui_maskarchivebox_CreateFcn(hObject, ~, ~)
% hObject    handle to gui_maskarchivebox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function gui_zoomout_Callback(hObject,~ , handles)
% hObject    handle to gui_zoomout (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if get(hObject,'Value') % is pushed down
    
    % create zoom object, save and enable
    handles.zoomhandle = zoom(handles.figure1);
    guidata(hObject,handles);
    set(handles.zoomhandle,'ActionPostCallback',@(hObject,eventdata)labelbox(...
        'justzoomed_Callback',hObject,eventdata,guidata(hObject)));
    set(handles.zoomhandle,'Direction','out');
    
    % grey out buttons
    grey_on_off(handles,'grey')
    set(handles.gui_zoomout,'Enable','on'); % turn back on zoomout
    
    % trun on magnifying glass
    set(handles.zoomhandle,'Enable','on');
    
    % message user
    changetxt(handles.mssgbox','IN ZOOM OUT MODE');
   
elseif get(hObject,'Value')==0 % was pushed down, now raised up
    
    % kill zoom
    set(handles.gui_zoomin,'Enable','off'); 
    zoom off; 
    
    % delete zoom object
    handles = rmfield(handles,'zoomhandle');
    
    % reenable %
    grey_on_off(handles,'ungrey')
      

    % clear box
    changetxt(handles.mssgbox','');
    
    % save
    guidata(hObject,handles);
end

function gui_zoomin_Callback(hObject, ~, handles)
% hObject    handle to gui_zoomin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


if get(hObject,'Value') % was pushed down
    % create zoom object, save and enable
    handles.zoomhandle = zoom(handles.figure1);
    guidata(hObject,handles);
    set(handles.zoomhandle,'ActionPostCallback',@(hObject,eventdata)labelbox(...
        'justzoomed_Callback',hObject,eventdata,guidata(hObject)));
    set(handles.zoomhandle,'Direction','in');
    
    % grey out buttons
    grey_on_off(handles,'grey')
    set(handles.gui_zoomin,'Enable','on'); % turn back on zoomin
    
    % trun on magnifying glass
    set(handles.zoomhandle,'Enable','on');
    
    % message user
    changetxt(handles.mssgbox','IN ZOOM IN MODE');
   
elseif get(hObject,'Value')==0 % was pushed down, now raised up
        
    % kill zoom
    set(handles.gui_zoomin,'Enable','off'); 
    zoom off; 
    
    % delete zoom object
    handles = rmfield(handles,'zoomhandle');
    
    % reenable %
    grey_on_off(handles,'ungrey')
      
    % clear box
    changetxt(handles.mssgbox','');
    
    % save
    guidata(hObject,handles);
end

function justzoomed_Callback(hObject,~,handles)

% get new axis settings
handles.axis = axis;

% save
guidata(hObject,handles);

function gui_maskarchivebox_Callback(hObject, ~, handles)
% hObject    handle to gui_maskarchivebox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns gui_maskarchivebox contents as cell array
%        contents{get(hObject,'Value')} returns selected item from gui_maskarchivebox
ind = get(hObject,'Value');

if isfield(handles,'currmask') && ind ~= handles.currmask;
    
    % take control
    grey_on_off(handles,'grey')
    
    handles.mask = handles.all_masks{ind};
    handles.currmask = ind;
    
    handles.rgbvalid = false(size(handles.rgbvalid));
    handles.rgb = zeros(size(handles.rgb)); 
    handles = replotim(handles,1);
    guidata(hObject, handles);
    changetxt(handles.mssgbox,'Loaded different mask');
 
    % return control
    grey_on_off(handles,'ungrey')

    
    set(handles.gui_maskarchivebox,'Value',handles.currmask);
end

function gui_pan_Callback(hObject, ~, handles)
% hObject    handle to gui_pan (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if get(hObject,'Value') % is pushed down
    
    % create gui_pan object, save and enable
    handles.panhandle = pan(handles.figure1);
    guidata(hObject,handles);
    set(handles.panhandle,'ActionPostCallback',@(hObject,eventdata)labelbox(...
        'justzoomed_Callback',hObject,eventdata,guidata(hObject)));
    
    % grey out buttons
    grey_on_off(handles,'grey')
    set(handles.gui_pan,'Enable','on'); % turn back on zoomout
    
    % trun on magnifying glass
    set(handles.gui_pan,'Enable','on');
    pan on;
    
    % message user
    changetxt(handles.mssgbox','IN PAN MODE');
   
elseif get(hObject,'Value')==0 % was pushed down, now raised up
    
    % kill gui_pan
    set(handles.gui_pan,'Enable','off'); 
    pan off; 
    
    % delete gui_pan object
    handles = rmfield(handles,'panhandle');
    
    % reenable %
    grey_on_off(handles,'ungrey')
      

    % clear box
    changetxt(handles.mssgbox','');
    
    % save
    guidata(hObject,handles);
end


%%% MOUSE/KEYBOARD CATCHING FUNCTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function axes1_ButtonDownFcn(~, ~, handles)

% check if double clikc 
if strcmp(get(handles.figure1,'SelectionType'),'open')
    
    % if this is an ok time to enter that function
    if strcmp(get(handles.gui_labelme,'Enable'),'on')
    
        gui_labelme_Callback(handles.gui_labelme, [], handles);
    end
end

function figure1_WindowScrollWheelFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  structure with the following fields (see FIGURE)
%	VerticalScrollCount: signed integer indicating direction and number of clicks
%	VerticalScrollAmount: number of lines scrolled for each click
% handles    structure with handles and user data (see GUIDATA)

if strcmp(get(gco,'type'),'image') || isempty(gco); % user focued on image
    % or user is over labelbox and hasn;t focused on anything else
    
    % update curr_sl (negative sign because scrolling was wierd the other way)
    handles.currsl = handles.currsl-eventdata.VerticalScrollCount;
    
    % onyl change slice and update handels struct if ok to do so
    if ~( handles.currsl > handles.top || handles.currsl < 1 ) ... 
        && strcmp(get(handles.slider1,'Enable'),'on');
        % in valid range & we're ok to plot
        handles = replotim(handles);
        guidata(hObject, handles);
    else 
    end 
end
axes(handles.axes1);


%%% UTILITY/ FUNCTIONS (TOOLS) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function changetxt(handle, str,opt)
% CHANGETXT(handle,str)
if nargin>2 && strcmp(opt,'-append');
    str = [get(handle,'String') str];
end
set(handle,'String',sprintf(str));

function handles = replotim(handles,varargin)
% changeable constants
alpha = .25; % change if you want to

% handle display limits (may or not be modified by gui_quicklut)
if isfield(handles,'lims');
    lims = handles.lims;
else
    lims = [0 1];
end

% special case: do the rgb math for all slices at once
 
if ~isempty(varargin) && varargin{1} == 1;
    handles.rgbvalid = false(size(handles.rgbvalid));
    swd = find(squeeze(sum(sum(handles.mask,1),2))>0); % S lices W ith D ata
    for ii = 1:length(swd)
        tmp = plot_segmentation_overlay(handles.im,handles.mask, ...
            alpha,cool,lims, swd(ii));
        handles.rgb(:,:,swd(ii),:) = permute(tmp,[1 2 4 3]);
        handles.rgbvalid(swd(ii))=true;
        
    end
end

% plot
axes(handles.axes1);
tmp = handles.mask(:,:,handles.currsl);

% figure out whether to plot mask, make and plot rgb, or just plot rgb
if ~any(tmp(:)); % no mask (all zeros)
    % plot black and white
    imshow(handles.im(:,:,handles.currsl),lims);
elseif handles.rgbvalid(handles.currsl) % already done this mask
    % plot rgb
    imagesc(squeeze(handles.rgb(:,:,handles.currsl,:)));
else % new mask
    % generate rbg
    tmp = plot_segmentation_overlay(handles.im,handles.mask, alpha,cool,...
        lims, handles.currsl);    
    % adjust handles thing
    handles.rgb(:,:,handles.currsl,:) = permute(tmp,[1 2 4 3]);
    handles.rgbvalid(handles.currsl)=true;
    % plot rgb
    imagesc(squeeze(handles.rgb(:,:,handles.currsl,:)));

end

% special case for just plot grayscale
if ~isempty(varargin) && varargin{1} == 2; 
    imshow(handles.im(:,:,handles.currsl));
end

% get correct looking image
daspect(handles.ax_pixdim); axis off;
if isfield(handles,'axis') && ~strcmp(handles.axis,'auto');
    axis(handles.axis);
end

% change slice number string.
set(handles.slicefield,'String', ...
    sprintf('%3i / %3i',handles.currsl,handles.top));

% put slider bar in correct spot
set(handles.slider1,'Value',handles.currsl);

% allows double clicking to enter labelling mode
imhandle = get(handles.axes1,'Children');
set(imhandle,'ButtonDownFcn',...
    @(hObject,eventdata)labelbox('axes1_ButtonDownFcn',hObject,eventdata,guidata(hObject)) )

function gui_render3d_Callback(~, ~, handles)
% hObject    handle to gui_render3d (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
fprintf('Generating 3D rendering. Please wait.\n');


if any(handles.mask(:)) && ~ismatrix(handles.im);
    g = figure;

    % crop way down to mask + buffer
    mask = handles.mask;
    buff = 10;
    r1 = max(find(sum(sum(mask,3),2)>0,1,'first')-buff,1);
    r2 = min(find(sum(sum(mask,3),2)>0,1,'last')+buff,size(mask,1));
    c1 = max(find(sum(sum(mask,3),1)>0,1,'first')-buff,1);
    c2 = min(find(sum(sum(mask,3),1)>0,1,'last')+buff,size(mask,2));
    z1 = max(find(sum(sum(mask,2),1)>0,1,'first')-buff,1);
    z2 = min(find(sum(sum(mask,2),1)>0,1,'last')+buff,size(mask,3));
    mask = mask(r1:r2,c1:c2,z1:z2);
    im = handles.im(r1:r2,c1:c2,z1:z2);
        
    % opts for render_3D_labels
    opts.cr_buffer = -1; % no cropping since I already did it
    opts.resdims = handles.ax_pixdim.^-1;
    opts.xslices = 'mid'; % 1 axial slice
    opts.yslices = 'mid'; % 1 corronal/sagittal
    opts.zslices = 'mid'; % 1 sag/corronal
    opts.fignum = g;
    opts.slicealpha = .5;
    
    % viewimg options
    if isfield(handles,'lims'); opts.ilim = handles.lims; end; % intensity lims
    opts.azimuth = -37.5;
    opts.elevation = 30;

    render_3D_labels(im, mask,opts);
else
    changetxt(handles.mssgbox,...
        'Mask empty or you have a 2D image. Not generating 3D.\n');
end

function grey_on_off(handles,instr)


f = fields(handles); 
inds = strncmp('gui',f,3);
list = f(inds);

if strcmp(instr,'grey')
    for ii = 1:length(list);
        if isfield(set(handles.(list{ii})),'Enable')
            set(handles.(list{ii}),'Enable','off');
        end
    end
elseif strcmp(instr,'ungrey')
    for ii = 1:length(list);
        if isfield(set(handles.(list{ii})),'Enable')
            set(handles.(list{ii}),'Enable','on');
        end
    end
else
    error('grey_on_off function only accepts ''grey'' and ''ungrey'' as instr');
end

function varargout = change_CLim(~,roihandle)

mask = createMask(roihandle);

% get cdata from image
im = get(findobj(gca,'type','image'),'CData');

% find min max of roi patch
patch = im(mask); 
lims = [min(patch), max(patch)];

% set clim of axis
if numel(lims)>0 
    set(gca,'CLim',lims)
%     fprintf('lims=%f %f\n',lims(1),lims(2));
end

if nargout > 0;
    varargout{1} = lims;
end

function gui_quicklut_Callback(hObject, ~, handles)
% hObject    handle to gui_quicklut (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% if this is not a good time, don't do anything
if strcmp(get(handles.gui_quicklut,'Enable'),'off');
    disp('Did not engage QuickLUT');
end

% change text
changetxt(handles.mssgbox,'IN QuickLUT MODE\nShowing greyscale');

% deactivate all buttons
grey_on_off(handles,'grey');

% reload original data
if isfield(handles,'orig_im');
    handles.im = handles.orig_im; 
end

% replot just greyscale
handles = replotim(handles,2); 

% function to constrain to box 
constfcn = makeConstrainToRectFcn('imrect',get(gca,'XLim'),get(gca,'YLim'));

% create imrect object using contraint function
h = imrect(handles.axes1,'PositionConstraintFcn',constfcn);

% add fucntion handle to call change_Clim
addNewPositionCallback(h, @(p) change_CLim(p,h));

% go ahead and call change CLim since it wasn't called during the initial 
% placement
change_CLim(getPosition(h),h);

% dont delete until user double clicks
wait(h); 

% user done:
% normal case
if exist('h','var'); 

    % get new CLims from change CLim 
    handles.lims  = change_CLim(getPosition(h),h); 

    % replot (allowing rgb) 
    handles = replotim(handles,1); 
    % 2nd arguemnt indicates to immediately regenerate rgb for all slices

    % save 
    guidata(hObject, handles);
    
    % print success
    changetxt(handles.mssgbox,'QuickLUT successful');
else
    % print failure
    changetxt(handles.mssgbox,'QuickLUT failed.');
end    

% reactivate all buttons
grey_on_off(handles,'ungrey');

function keyboardhit_ButtonDownFcn(hObject, eventdata, handles)
% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over keyboardhit.

% hObject    handle to keyboardhit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
disp('you hit the keyboard-debug button');
keyboard;




% BONUS/UNUSED CODE

% %  THIS WAS AN IDEA FOR THE GREY/UNGREY FUNCTION
% %     for ii = 1:length(list);
% %         if isfield(set(handles.(list{ii})),'Enable')
% %             try
% %                 set(handles.(list{ii}),'Enable','off');
% %             catch
% %
% %             end
% %         end
% %     end
% 
% % function out = interp_boundary(im1,im2)
% % 
% % mask = (im1+im2);
% % over = mask==2;
% % 
% % if ~any(over(:)); 
% %     % do nothing if no overlap
% % else
% %     skeleton = bwmorph(mask==1,'skel',inf);
% %     % takes area when one but not both overlapped. 
% %     
% %     
% 
% % --- Executes on selection change in gui_maskarchivebox.
