function h = gkernel(p2,p3)
% gaussian filter creation function
% h_matrix = GKERNEL(size_array, standard_deviation_array)
% copied from fspecial, but made so that it works for 3d and can have a
% different std dev in 3d.
siz   = (p2-1)/2;
std   = p3;

%handle optionally different std devs.
if length(std)<length(siz) && length(std) == 1
    std = std*ones(size(siz));
end

if length(siz) == 2
    [x,y] = meshgrid(-siz(2):siz(2),-siz(1):siz(1));
    arg = -(x.*x/std(1)^2 + y.*y/std(2)^2)/(2);
elseif length(siz) == 3
    [x,y,z] = meshgrid(-siz(2):siz(2),-siz(1):siz(1),-siz(3):siz(3));
    arg = -(x.*x/std(1)^2+ y.*y/std(2)^2+ z.*z/std(3)^2)/(2);
end

h = exp(arg);
h(h<eps*max(h(:))) = 0;

sumh = sum(h(:));
if sumh ~= 0,
    h  = h/sumh;
end;