function render_3D_truth(truth, fignum, res_dims)
% RENDER_3D_TRUTH - renders a 3D representation of a segmentation
%
% render_3D_truth(truth, fignum, res_dims)
%
% Input: truth - the true segmentation
%        fignum - the figure number to show the result
%        res_dims - the resolution of the X Y Z dimensions
%
% Output: None

iso1 = isosurface(truth == 1);

num = size(iso1.vertices, 1);

figure(fignum); clf;
patch('Vertices', iso1.vertices, ...
      'Faces', iso1.faces, ...
      'FaceVertexCData', repmat([1 0 1], [num 1]), ...
      'FaceColor', 'interp', ...
      'EdgeColor', 'none');
daspect(1 ./ res_dims);
view(90, -90);
camlight;
lighting phong;
set(gca, 'Visible', 'off')
colorbar;

