function [voldiff meanvol] = volume_difference(truth, estimate, res_dims)
% LABEL_VOLUME - returns the label volume difference between a true segmentation
%                and an estimate
%
% [voldiff meanvol] = volume_difference(truth, estimate, res_dims)
%
% Input: truth - the true segmentation
%        estimate - the estimated segmentation
%        res_dims - the resolution of each dimension
%
% Output: voldiff - the volume difference
%         meanvol - the mean volume
%

numvox = length(find(truth == 1));
vol1 = numvox * prod(res_dims);
numvox = length(find(estimate == 1));
vol2 = numvox * prod(res_dims);
meanvol = mean([vol1 vol2]);
voldiff = abs(vol1 - vol2) / meanvol;

