function write_nls_file(fname, data, typ, varargin)
% WRITE_NLS_FILE - function that saves a Non-Local STAPLE compatible, file
%                  usually referred to as a mff file
%
% write_nls_file(fname, data, typ)
%
% Input: fname - the filename of the output file
%        data - the data to write
%        typ - the data type of the data to write (e.g., 'double', 'uint8')
%
% Output: NONE

if length(varargin) == 1
    num_dims = varargin{1};
else
    num_dims = max([3, length(size(data))]);
end

sd = size(data);
for i = (length(sd)+1):num_dims
    sd(i) = 1;
end
fid = fopen(fname, 'w');
fwrite(fid, sd, 'uint64');
fwrite(fid, data, typ);
fclose(fid);
