% testing script for the STAPLE algorithm

% load the example data
load example-data.mat obs truth

% fusion settings
epsilon = 0.001;
init_flag = 0;
prior_flag = 0;
cf1 = 0;
cf2 = 1;

% construct a "perfect" spatially varying prior
svprior = zeros([size(truth) length(unique(truth))]);
for x = 1:size(truth, 1)
    for y = 1:size(truth, 2)
        for z = 1:size(truth, 3)
            svprior(x, y, z, truth(x, y, z)+1) = 1;
        end
    end
end

% run the STAPLE algorithm
[S_est_1 S_W_1 S_theta_1] = STAPLE(obs, epsilon, prior_flag, init_flag, cf1);
[S_est_2 S_W_2 S_theta_2] = STAPLE(obs, epsilon, svprior, init_flag, cf1);
[S_est_3 S_W_3 S_theta_3] = STAPLE(obs, epsilon, prior_flag, init_flag, cf2);

% print the results to the screen
disp(['STAPLE: ' num2str(fraction_correct(truth, S_est_1))]);
disp(['STAPLE (SV-prior): ' num2str(fraction_correct(truth, S_est_2))]);
disp(['STAPLE (ic): ' num2str(fraction_correct(truth, S_est_3))]);
