% testing script for the STAPLER algorithm

% load the example data
load example-data.mat obs truth

% fusion settings
epsilon = 0.001;
init_flag = 0;
prior_flag = 0;
cf1 = 0;
cf2 = 1;

% construct a "perfect" spatially varying prior
svprior = zeros([size(truth) length(unique(truth))]);
for x = 1:size(truth, 1)
    for y = 1:size(truth, 2)
        for z = 1:size(truth, 3)
            svprior(x, y, z, truth(x, y, z)+1) = 1;
        end
    end
end

% calculate the true biasing theta
[bias_theta tr_theta] = construct_theta_bias(obs, truth, obs, cf1);

% run the STAPLER algorithm
[SR_est_1 SR_W_1 SR_theta_1] = STAPLER(obs, epsilon, prior_flag, ...
                                       init_flag, cf1, bias_theta);
[SR_est_2 SR_W_2 SR_theta_2] = STAPLER(obs, epsilon, svprior, ...
                                       init_flag, cf1, bias_theta);

% calculate the true biasing theta
[bias_theta tr_theta] = construct_theta_bias(obs, truth, obs, cf2);

[SR_est_3 SR_W_3 SR_theta_3] = STAPLER(obs, epsilon, prior_flag, ...
                                       init_flag, cf2, bias_theta);


% print the results to the screen
disp(['STAPLER: ' num2str(fraction_correct(truth, SR_est_1))]);
disp(['STAPLER (SV-prior): ' num2str(fraction_correct(truth, SR_est_2))]);
disp(['STAPLER (ic): ' num2str(fraction_correct(truth, SR_est_3))]);
