% testing script for the SpatialSTAPLE algorithm

% load the example data
load example-data.mat obs truth

% fusion settings
epsilon = 1e-5;
init_flag = 0;
prior_flag = 0;
interp_type_1 = 0;
interp_type_2 = 1;
cf1 = 0;
cf2 = 1;
num_up = [20 20 20];
win_dims = [5 5 5];
bias = prod(win_dims) / length(unique(truth));

% construct a "perfect" spatially varying prior
svprior = zeros([size(truth) length(unique(truth))]);
for x = 1:size(truth, 1)
    for y = 1:size(truth, 2)
        for z = 1:size(truth, 3)
            svprior(x, y, z, truth(x, y, z)+1) = 1;
        end
    end
end

% calculate the true biasing theta
[bias_theta tr_theta] = construct_theta_bias(obs, truth, obs, cf1);

% run the SpatialSTAPLE algorithm
[SS_est_1 SS_W_1 SS_theta_1] = SpatialSTAPLE(obs, epsilon, svprior, ...
                                             init_flag, cf1, interp_type_1, ...
                                             num_up, win_dims, bias);
[SS_est_2 SS_W_2 SS_theta_2] = SpatialSTAPLE(obs, epsilon, prior_flag, ...
                                             init_flag, cf1, interp_type_1, ...
                                             num_up, win_dims, bias);
[SS_est_3 SS_W_3 SS_theta_3] = SpatialSTAPLE(obs, epsilon, prior_flag, ...
                                             init_flag, cf1, interp_type_2, ...
                                             num_up, win_dims, bias);
[SS_est_4 SS_W_4 SS_theta_4] = SpatialSTAPLE(obs, epsilon, prior_flag, ...
                                             init_flag, cf1, interp_type_1, ...
                                             num_up, win_dims, bias, ...
                                             tr_theta);
[SS_est_5 SS_W_5 SS_theta_5] = SpatialSTAPLE(obs, epsilon, prior_flag, ...
                                             init_flag, cf1, interp_type_2, ...
                                             num_up, win_dims, bias, ...
                                             tr_theta);

% calculate the true biasing theta
[bias_theta tr_theta] = construct_theta_bias(obs, truth, obs, cf2);

[SS_est_6 SS_W_6 SS_theta_6] = SpatialSTAPLE(obs, epsilon, prior_flag, ...
                                             init_flag, cf2, interp_type_1, ...
                                             num_up, win_dims, bias, ...
                                             tr_theta);
[SS_est_7 SS_W_7 SS_theta_7] = SpatialSTAPLE(obs, epsilon, prior_flag, ...
                                             init_flag, cf2, interp_type_2, ...
                                             num_up, win_dims, bias, ...
                                             tr_theta);

% print the results to the screen
disp(['Spatial STAPLE (default, nn, sv, nc): ' ...
      num2str(fraction_correct(truth, SS_est_1))]);
disp(['Spatial STAPLE (default, nn, global, nc): ' ...
      num2str(fraction_correct(truth, SS_est_2))]);
disp(['Spatial STAPLE (default, lin, global, nc): ' ...
      num2str(fraction_correct(truth, SS_est_3))]);
disp(['Spatial STAPLE (true, nn, global, nc): ' ...
      num2str(fraction_correct(truth, SS_est_4))]);
disp(['Spatial STAPLE (true, lin, global, nc): ' ...
      num2str(fraction_correct(truth, SS_est_5))]);
disp(['Spatial STAPLE (true, nn, global, ic): ' ...
      num2str(fraction_correct(truth, SS_est_6))]);
disp(['Spatial STAPLE (true, lin, global, ic): ' ...
      num2str(fraction_correct(truth, SS_est_7))]);
