% testing script for the voting based algorithms
%  - Majority Vote
%  - Globally Weighted Vote
%  - Locally Weighted Vote

% load the example data
load example-data.mat obs truth

% construct the weights
globalweights = zeros([1 obs.num_obs]);
localweights = zeros([obs.dims obs.num_obs]);
for r = 1:obs.num_obs
    globalweights(r) = dice(truth, obs.data{r});
    localweights(:, :, :, r) = globalweights(r);
end

% run the majority vote algorithm
MV_est_1 = majority_vote(obs);
[MV_est_2 MV_W_2] = majority_vote(obs);

% run the weighted vote algorithm
WV_est_1 = weighted_vote(obs, globalweights);
[WV_est_2 WV_W_2] = weighted_vote(obs, globalweights);
WV_est_3 = weighted_vote(obs, localweights);
[WV_est_4 WV_W_4] = weighted_vote(obs, localweights);

% display the results to the screen
disp(['Majority Vote (fast): ' num2str(fraction_correct(truth, MV_est_1))]);
disp(['Majority Vote: ' num2str(fraction_correct(truth, MV_est_2))]);
disp(['Globally Weighted Vote (fast): ' ...
      num2str(fraction_correct(truth, WV_est_1))]);
disp(['Globally Weighted Vote: ' num2str(fraction_correct(truth, WV_est_2))]);
disp(['Locally Weighted Vote (fast): ' ...
      num2str(fraction_correct(truth, WV_est_3))]);
disp(['Locally Weighted Vote: ' num2str(fraction_correct(truth, WV_est_4))]);

