#ifndef CORRECTION_H
#define CORRECTION_H

void usage();

void set_input_args(int argc,
                    char ** argv,
                    char ** targfile,
                    char ** obsfile,
                    size_t * ns,
                    size_t * nc,
                    intensity_t * coefs,
                    intensity_t * stdev,
                    intensity_t * sp_stdev,
                    char ** outfile);

void print_input_parms(char * targfile,
                       char * obsfile,
                       size_t * dims,
                       size_t * ns,
                       size_t * nc,
                       size_t num_raters,
                       size_t num_labels,
                       intensity_t * coefs,
                       intensity_t stdev,
                       intensity_t sp_stdev);

void save_results(size_t * dims,
                  char * outfile,
                  char * targfile,
                  label_t *** estimate);

void reset_target_intensity(intensity_t *** target,
                            label_t *** est,
                            size_t * dims);

void set_dist_factor(size_t * nsf,
                     size_t * ns,
                     intensity_t sp_stdev,
                     intensity_t *** dist_factor);

void get_majority_vote_consensus(bool *** cons,
                                 label_t **** obs,
                                 size_t num_raters,
                                 size_t * dims);

void set_majority_vote_info(bool *** cons,
                            label_t **** obs,
                            size_t num_raters,
                            size_t num_labels,
                            size_t * dims,
                            intensity_t **** prior,
                            label_t *** est);

void initialize_consensus_estimate(bool *** con,
                                   label_t *** est,
                                   size_t * ns,
                                   size_t * dims);

void update_consensus_estimate(bool *** consensus,
                               bool *** consensus2,
                               label_t **** estnl,
                               intensity_t **** alphanl,
                               size_t num_keep,
                               size_t * dims);

intensity_t get_kl_fact(int xp,
                        int yp,
                        int zp,
                        size_t * dims,
                        size_t * nc,
                        intensity_t *** target,
                        intensity_t ff,
                        intensity_t * cdens,
                        intensity_t * pdens,
                        intensity_t * xkl,
                        size_t num_bins);

intensity_t get_norm_diff(int x,
                          int y,
                          int z,
                          int xp,
                          int yp,
                          int zp,
                          size_t * dims,
                          size_t * nc,
                          intensity_t *** target);

void set_target_density(int x,
                        int y,
                        int z,
                        size_t * dims,
                        size_t * nc,
                        size_t num_bins,
                        intensity_t ff,
                        intensity_t * dens,
                        intensity_t * xkl,
                        intensity_t *** target);

void set_alpha_for_voxel(int x,
                         int y,
                         int z,
                         size_t num_keep,
                         size_t * dims,
                         size_t * ns,
                         size_t * nc,
                         intensity_t ff,
                         intensity_t **** alphanl,
                         intensity_t * alphar,
                         label_t ***** locnl,
                         label_t ** locr,
                         intensity_t *** target,
                         intensity_t *** dist_factor);

void set_nonlocal_data(intensity_t *** target,
                       bool *** consensus,
                       intensity_t **** alphanl,
                       label_t ***** locnl,
                       size_t * dims,
                       size_t * nc,
                       size_t * ns,
                       size_t * nsf,
                       size_t num_keep,
                       intensity_t stdev,
                       intensity_t sp_stdev);

double get_convergence_factor_est(label_t *** est,
                                  label_t *** estp,
                                  bool *** cons,
                                  size_t * dims);

intensity_t ** get_transition_probabilities(label_t **** obs,
                                            bool *** cons,
                                            size_t * dims,
                                            size_t * ns,
                                            size_t num_labels,
                                            size_t num_raters,
                                            size_t num_keep);

void apply_MRF_voxel(size_t x,
                     size_t y,
                     size_t z,
                     bool *** cons,
                     size_t num_labels,
                     size_t num_keep,
                     intensity_t * coefs,
                     intensity_t **** alphanl,
                     label_t ***** locnl,
                     intensity_t ** G,
                     label_t *** est,
                     label_t *** estp,
                     intensity_t **** W,
                     intensity_t **** Wp,
                     intensity_t **** prior);

void run_correction_algorithm(label_t *** est,
                              intensity_t **** W,
                              intensity_t **** prior,
                              intensity_t **** alphanl,
                              label_t ***** locnl,
                              intensity_t ** G,
                              intensity_t * coefs,
                              bool *** cons,
                              size_t * dims,
                              size_t num_keep,
                              size_t num_labels);
#endif
