#ifndef FUSION_TOOLS_H
#define FUSION_TOOLS_H
#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))

void normalize_intensity_unit(intensity_t *** target,
                              label_t *** est,
                              intensity_t **** ims,
                              label_t **** obs,
                              const size_t * dims,
                              const size_t num_raters);

void normalize_intensity_poly(intensity_t *** target,
                              label_t *** est,
                              intensity_t **** ims,
                              label_t **** obs,
                              const size_t * dims,
                              const size_t num_raters,
                              const size_t num_labels,
                              const size_t num_coef);

void normalize_intensity_decay(intensity_t *** target,
                               label_t *** est,
                               intensity_t **** ims,
                               label_t **** obs,
                               const size_t * dims,
                               const size_t num_raters,
                               const intensity_t rho);

void normalize_intensity(intensity_t *** target,
                         label_t *** est,
                         intensity_t **** ims,
                         label_t **** obs,
                         const size_t * dims,
                         const size_t num_raters,
                         const size_t num_labels,
                         const size_t num_coef,
                         const intensity_t rho);

void print_status(size_t ind,
                  size_t num);

#endif
