% this example is a simple label size variation example where the accuracy of
% STAPLE and STAPLER are compared with respect to varying ppv value

% simulation settings
num_raters = 5;
dims = [100 100 25];
ppv = linspace(0.2, 0.9, 20);
num_labels = 5;
mci = 10;

% algorithm settings
init_flag = 0;
prior_flag = 0;
cons_flag = 0;
epsilon = 0.001;

% allocate space for the results
results = zeros(3, length(ppv), mci);

% random label sizes
for i = 1:length(ppv)
    for m = 1:mci

        % set the appropriate label sizes
        label_size = [0.8, 0.025, 0.025, 0.025, 0.025, ...
                           0.025, 0.025, 0.025, 0.025];

        % run the simulation
        [obs tobs cms ppvs truth] = label_variation_simulation(...
                                                          num_raters, dims, ...
                                                          label_size, ...
                                                          ppv(i), ppv(i));

        % construct the theta bias based upon the training data
        [theta_bias training_theta] = construct_theta_bias(tobs, truth, obs);

        % run the algorithms
        [S_est S_W S_theta] = STAPLE(obs, epsilon, prior_flag, ...
                                     init_flag, cons_flag);
        [SR_est SR_W SR_theta] = STAPLER(obs, epsilon, prior_flag, ...
                                         init_flag, cons_flag, theta_bias);
        [MV_est] = majority_vote(obs);

        % save the accuracy results
        results(1, i, m) = fraction_correct(truth, S_est);
        results(2, i, m) = fraction_correct(truth, SR_est);
        results(3, i, m) = fraction_correct(truth, MV_est);
    end
end

% formulate the results
x = ppv;
es = std(results(1, :, :), [], 3);
ys = mean(results(1, :, :), 3);
esr = std(results(2, :, :), [], 3);
ysr = mean(results(2, :, :), 3);
em = std(results(3, :, :), [], 3);
ym = mean(results(3, :, :), 3);


% plot the full results
figure(1);
ms = 7;
errorbar(x, ys, es, 'b*--', 'MarkerSize', ms);
hold on
errorbar(x, ysr, esr, 'k--', 'MarkerSize', ms);
errorbar(x, ym, em, 'ro--', 'MarkerSize', ms);
hold off
xlabel('Positive Predictive Value');
ylabel('Fraction Voxels Correct');
legend({'STAPLE'; 'STAPLER'; 'Majority Vote'}, 0);
xlim([0.18 0.92]);

% plot the 'high ppv' results
figure(2);
ms = 8;
errorbar(x(end-5:end), ys(end-5:end), es(end-5:end), 'b*--', 'MarkerSize', ms, 'LineWidth', 1);
hold on
errorbar(x(end-5:end), ysr(end-5:end), esr(end-5:end), 'k--', 'MarkerSize', ms, 'LineWidth', 1);
errorbar(x(end-5:end), ym(end-5:end), em(end-5:end), 'ro--', 'MarkerSize', ms, 'LineWidth', 1);
hold off
xlabel('Positive Predictive Value');
ylabel('Fraction Voxels Correct');
ylim([0.9775 1.0001])
xlim([0.7 0.91])

% calculate the pvals
pvals = zeros(length(ppv), 2);
for i = 1:length(ppv)
    [h p ci] = ttest(results(2, i, :), results(1, i, :));
    pvals(i, 1) = p;
    [h p ci] = ttest(results(2, i, :), results(3, i, :));
    pvals(i, 2) = p;
end

