% script that tests the validity of the multi-collate approach

% fusion settings
num_raters = 15;
epsilon = 0.001;
init_flag = 0;
cons_flag = 0;
prior_flag = 0;
alphas = [0 0.5 2 1e5];
cval = [0.45 0.7 0.99];
alphasb = [0 1e5];
cvalb = [0.99];

% run the simulation
[obs truth] = multi_COLLATE_simulation(alphas, num_raters);

% run the algorithms
[MV_est] = majority_vote(obs);
[MC_est MC_W MC_theta] = COLLATE(obs, epsilon, prior_flag, ...
                                 init_flag, alphas, cval);
[C_est C_W C_theta] = COLLATE(obs, epsilon, prior_flag, init_flag, ...
                              alphasb, cvalb);
[S_est S_W S_theta] = STAPLE(obs, epsilon, prior_flag, init_flag, cons_flag);

% show the results
figure(1);
subplot(2, 3, 1);
imagesc(truth(:, :, 1));
title('True Segmentation');
subplot(2, 3, 2);
imagesc(obs.data{5}(:, :, 1));
title('Example Observation');
subplot(2, 3, 3);
imagesc(MV_est(:, :, 1));
title('Majority Vote Estimate');
subplot(2, 3, 4);
imagesc(S_est(:, :, 1));
title('STAPLE Estimate');
subplot(2, 3, 5);
imagesc(C_est(:, :, 1));
title('Binary COLLATE Estimate');
subplot(2, 3, 6);
imagesc(MC_est(:, :, 1));
title('Multi-COLLATE Estimate');

% print the accuracy levels to the screen
disp(['Majority Vote Accuracy: ', num2str(fraction_correct(truth, MV_est))]);
disp(['STAPLE Accuracy: ', num2str(fraction_correct(truth, S_est))]);
disp(['Binary-COLLATE Accuracy: ', num2str(fraction_correct(truth, C_est))]);
disp(['Multi-COLLATE Accuracy: ', num2str(fraction_correct(truth, MC_est))]);
