% This MATLAB script sets up your path and javapath so that the labeling
% code can be successfully used.

clear all
close all
clear java

% get the currect directory
curr_dir = pwd;

% add the shared code (main MATLAB code)
shared_dir = [curr_dir, '/src/shared/'];
addpath(shared_dir);

% add the external code (nifti tools)
ext_dir = [curr_dir, '/src/ext/'];
addpath(ext_dir);

% add the simulations
sim_dir = [curr_dir, '/src/simulations/'];
addpath(sim_dir);

% add the multi-atlas code (large-scale processing)
ext_dir = [curr_dir, '/src/multi-atlas/'];
addpath(ext_dir);

% add the java classes
java_dir = [curr_dir, '/bin/'];
javaaddpath(java_dir);

recJavaMB = 2048;

javaMemMB = (java.lang.Runtime.getRuntime.maxMemory)/2^20;
disp(sprintf('You have %.0f MB of RAM allocated to Java.\n',javaMemMB));
if javaMemMB < recJavaMB
    disp(sprintf('***************************************************************'));
    disp(sprintf('We suggest at least %.0f MB for this labeling system.\n',recJavaMB));
    disp(sprintf('To change this settng, create a file called java.opts in the '));
    disp(sprintf('directory where you started Matlab with the contents "-Xmx%dm"',recJavaMB));
    disp(sprintf('(without quotes) and restart Matlab.'));
    disp(sprintf('***************************************************************'));
end

clear all
