function savePAR(parrec, filename,quantizer)
%           Jun 16 2005 - Forced to retain file format
if(isfield(parrec,'hdr'))
    par = parrec.hdr;
else
    par =parrec;
end
fp = fopen(filename,'wt');

[emptypar,vars,slicevars] = defaultPARVars;
for j=1:length(par.fmt)
    if(strcmp(par.fmt{j}{1},'comment'))
        s= strtrim(par.fmt{j}{2});
        if(length(s)>0)
        fprintf(fp,'%s \n',s);
        else
        fprintf(fp,'\n');    
        end
    end
    if(strcmp(par.fmt{j}{1},'var'))
        idx1=strmatch(par.fmt{j}{2},vars(:,2));
        idx2=strmatch(par.fmt{j}{3},vars(:,3));
        p = intersect(idx1,idx2);
        if(isnumeric(par.(par.fmt{j}{2}).(par.fmt{j}{3})))
            fprintf(fp,'%s: %s\n',(vars{p(1),1}),strtrim(num2str(par.(par.fmt{j}{2}).(par.fmt{j}{3}))));
        else
            fprintf(fp,'%s: %s\n',(vars{p(1),1}),strtrim((par.(par.fmt{j}{2}).(par.fmt{j}{3}))));
        end
    end
    if(strcmp(par.fmt{j}{1},'SLICES'))
        for k=1:length(par.img)

            for m=1:length(par.scnfmt)
		try %2008.1.3bl
                	v=num2str(par.img(k).(par.scnfmt{m}{2}).(par.scnfmt{m}{3}));
                catch
                    	v='-1';
                    	if(k==1)
                    		warning(['savePAR: PAR file version/key mismatch: ' par.scnfmt{m}{2} '.' par.scnfmt{m}{3} ' Defaulting to -1.']);
                    	end
                end
%                v=num2str(par.img(k).(par.scnfmt{m}{2}).(par.scnfmt{m}{3}));
                for l=1:size(v,1)
                    fprintf(fp,'%s ',v(l,:));
                end
            end
            fprintf(fp,'\n');
        end
    end
    
end

fclose(fp);
return;

fprintf(fp,'# === DATA DESCRIPTION FILE ======================================================\n');
fprintf(fp,'#\n');
fprintf(fp,'# Generated by savePAR (BL''s fileformats_toolbox, 2005)');
fprintf(fp,'#\n');
fprintf(fp,'# === GENERAL INFORMATION =======================================================\n#\n');


[emptypar,vars,slicevars] = defaultPARVars;
cats = fieldnames(parrec.hdr);
for j=1:length(cats)
    if(and(~strcmp(cats{j},'img'),~strcmp(cats{j},'NumberOfVolumes')))
        vals = fieldnames(parrec.hdr.(cats{j}));
        for k=1:length(vals)
            idx1=strmatch(cats(j),vars(:,2));
            idx2=strmatch(vals(k),vars(:,3));
            p = intersect(idx1,idx2);
            if(isnumeric(parrec.hdr.(cats{j}).(vals{k})))
                fprintf(fp,'%s: %s\n',vars{p(1),1},num2str(parrec.hdr.(cats{j}).(vals{k})));
            else
                fprintf(fp,'%s: %s\n',vars{p(1),1},(parrec.hdr.(cats{j}).(vals{k})));
            end
        end
    end
end

fprintf(fp,'#\n');
fprintf(fp,'# === PIXEL VALUES =============================================================\n');
fprintf(fp,'#  PV = pixel value in REC file, FP = floating point value, DV = displayed value on console\n');
fprintf(fp,'#  RS = rescale slope,           RI = rescale intercept,    SS = scale slope\n');
fprintf(fp,'#  DV = PV * RS + RI             FP = DV / (RS * SS)\n');
fprintf(fp,'#\n');
fprintf(fp,'# === IMAGE INFORMATION DEFINITION =============================================\n');
fprintf(fp,'#  The rest of this file contains ONE line per image, this line contains the following information:\n');
fprintf(fp,'#\n');

cats = fieldnames(parrec.hdr.img);
for j=1:length(cats)

    vals = fieldnames(parrec.hdr.img(1).(cats{j}));

    for k=1:length(vals)
        if(or(~strcmp(cats{j},'orient'),~strcmp(vals{k},'orient')))
            idx1=strmatch(cats(j),slicevars(:,3));
            idx2=strmatch(vals(k),slicevars(:,4));
            p = intersect(idx1,idx2);

            fprintf(fp,'%s\n',slicevars{p(1),1});
        end

    end

end


fprintf(fp,'#\n');
fprintf(fp,'# === IMAGE INFORMATION ==========================================================\n');
fprintf(fp,'# See above for definition.\n');
fprintf(fp,'\n');


for m=1:length(parrec.hdr.img)
    parrec.hdr.img(m).vis.scale_slope = quantizer;
    for j=1:length(cats)

        vals = fieldnames(parrec.hdr.img(1).(cats{j}));

        for k=1:length(vals)
            if(or(~strcmp(cats{j},'orient'),~strcmp(vals{k},'orient')))
                v=num2str(parrec.hdr.img(m).(cats{j}).(vals{k}));
                for l=1:size(v,1)
                    fprintf(fp,'%s\t',v(l,:));
                end
            end
        end
    end
    fprintf(fp,'\n');
end

fprintf(fp,'\n#\n');
fprintf(fp,'# === END OF DATA DESCRIPTION FILE ===============================================\n');
fclose(fp);
