function varargout = get_target_obs(targetname, labelnames, imnames)
% GET_TARGET_OBS - get the target intensity image and the atlas information
%                  given a set of provided filenames.
%
% Two Forms:
% 1) obs = get_target_obs(targetname, labelnames, imnames);
% 2) [obs ims target] = get_target_obs(targetname, labelnames, imnames);
%
% Input: targetname - the filename of the target intensity volume
%        labelnames - a cell array of the registered labeled atlases filenames
%        imnames - a cell array of the registered atlas intensity filenames
%
% Output: obs - the atlas observation struct
%         ims - (Optional) the atlas intensity volumes
%         target - (Optional) the target image volume
%

% settings
num_atlases = length(labelnames);

if nargout ~= 1 && nargout ~= 3
    error('Invalid number of output arguments to get_target_obs.m');
end

% allocate the atlas information
dims = [0 0 0];
for i = 1:num_atlases
    % load the label estimate
    if strcmp(labelnames{i}(end-1:end), 'gz')
        a = load_untouch_nii_gz(labelnames{i});
    else
        a = load_untouch_nii(labelnames{i});
    end
    if i == 1
        dims = size(a.img);
        obs = create_obs('volume', dims);
    end
    obs = add_obs(obs, a.img);
end
varargout{1} = obs;
clear obs;

if nargout == 3

    % allocate the atlas information
    ims = zeros([dims, num_atlases]);
    for i = 1:num_atlases

        % load the intensity image
        if strcmp(imnames{i}(end-1:end), 'gz')
            a = load_untouch_nii_gz(imnames{i});
        else
            a = load_untouch_nii(imnames{i});
        end
        ims(:, :, :, i) = double(a.img);

    end
    varargout{2} = ims;
    clear ims;

    % load the target intensity image
    if strcmp(targetname(end-1:end), 'gz')
        a = load_untouch_nii_gz(targetname);
    else
        a = load_untouch_nii(targetname);
    end
    target = double(a.img);
    varargout{3} = target;
    clear target;
end
