function cmd_out = prepend_jist_cluster_prefix(cmd_in, sleepnum, tmpdir, suffix)
% PREPEND_JIST_CLUSTER_PREFIX - prepends the xvfb prefix
%
% cmd_out = prepend_jist_cluster_prefix(cmd_in, sleepnum, tmpdir, suffix)
%
% Input: cmd_in - the input command
%        sleepnum - the number of seconds to sleep
%        tmpdir - the location to keep temporary files
%        suffix - the suffix for the temporary files (so they are unique)
%
% Output: cmd_out - the output command

% create the temporary filenames
xvfb_fname = sprintf('%s/xvfb-run_%s.auth', tmpdir, suffix);
null_fname = sprintf('%s/null_%s.err', tmpdir, suffix);

% create the cluster prefix
num = 99 + mod(sum(uint8(suffix)), 100);
cluster_prefix = sprintf(['xvfb-run -f %s -e %s -n %d -a ', ...
                          '--server-args="-screen 0 1600x1280x24 -ac ', ...
                          '-extension GLX"'], xvfb_fname, null_fname, num);

% turn the cmds into a single string
if iscell(cmd_in)
    cmd_full = [];
    num_cmds = length(cmd_in);
    for i = 1:num_cmds
        cmd_full = [cmd_full, cmd_in{i}, ' && '];
    end
else
    cmd_full = [cmd_in, ' && '];
end
cmd_full = strrep(cmd_full, sprintf('\n'), sprintf(''));

% prepend to the command
cmd_out{1} = sprintf('sleep %d && %s %s rm %s %s\n', ...
                    sleepnum, cluster_prefix, cmd_full, xvfb_fname, null_fname);

