function cmds = run_joint_fusion(fuse_file, reg_labels, target_name, reg_ims, opts);
% RUN_JOINT_FUSION - run joint label fusion
%
% cmds = run_joint_fusion(fuse_file, reg_labels, target_name, reg_ims, opts);
%
% Input: fuse_file - the output fused file
%        reg_labels - the registered labels names (cell array)
%        target_name - the target image name
%        reg_ims - the registered atlas names (cell array)
%        opts - the options
%
% Output: cmds - the cell array of output commands
%              - to run on your local machine, run system(cmds{1});
%
% --- Available Options ---
%
% opts.searchradius - the search radii (default: '3x3x3');
% opts.patchradius - the patch radii (default: '2x2x2');
% opts.method - the fusion method (default: 'Joint[0.1,2]')
% opts.loc - the fusion location (default: 'system('which jointfusion')')
% opts.prependbash - boolean for prepending the bashrc (default: true)
%

cmds = {};

% options
if ~isfield(opts, 'searchradius'), opts.searchradius = '3x3x3'; end
if ~isfield(opts, 'patchradius'), opts.patchradius = '2x2x2'; end
if ~isfield(opts, 'method'), opts.method = 'Joint[0.1,2]'; end
if ~isfield(opts, 'loc')
    [result, opts.loc] = system('which jointfusion');
    if (result ~= 0)
        error('unable to find jointfusion binary in your path');
    end
    opts.loc = strtrim(opts.loc);
end
if ~isfield(opts, 'prependbash'), opts.prependbash = true; end

% set the atlas strings
atlas_seg_str = '';
for i = 1:length(reg_labels)
    atlas_seg_str = sprintf('%s%s ', atlas_seg_str, reg_labels{i});
end
atlas_seg_str = atlas_seg_str(1:end-1);

atlas_im_str = '';
for i = 1:length(reg_ims)
    atlas_im_str = sprintf('%s%s ', atlas_im_str, reg_ims{i});
end
atlas_im_str = atlas_im_str(1:end-1);

% create the command
cmds{1} = sprintf('%s 3 -g %s -l %s -m %s -rp %s -rs %s %s %s\n', ...
                  opts.loc, atlas_im_str, atlas_seg_str, opts.method, ...
                  opts.patchradius, opts.searchradius, target_name, fuse_file);

% prepend the bashrc if we need to
if (opts.prependbash), cmds{1} = sprintf('. ~/.bashrc && %s', cmds{1}); end

