function [cmds chk_files] = ...
                      run_niftyreg_registration(target, atlas, labels, ...
                                                out_prefix, out_type, ...
                                                out_warp_dir, out_seg_dir, ...
                                                out_atlas_dir, out_temp_dir, ...
                                                regloc, opts);
% RUN_NIFTYREG_REGISTRATION - runs the aladin registration algorithm between
%                           a given target and an atlas with labels
%
% [cmds chk_files] = run_niftyreg_registration(target, atlas, labels, ...
%                                              out_prefix, out_type, ...
%                                              out_warp_dir, out_seg_dir, ...
%                                              out_atlas_dir, out_temp_dir, ...
%                                              regloc, opts);
%
% Input: target - the target filename
%        atlas - the atlas filename
%        labels - the atlas labels filename
%        out_prefix - the output prefix for the filenames
%        out_type - the output filetype (1 - .nii, 2 - .nii.gz)
%        out_warp_dir - the output directory for the warp files
%        out_seg_dir - the output directory for the segmentation files
%        out_atlas_dir - the output directory for the registred atlas files
%        out_temp_dir - the output directory to store the temporary files
%        regloc - the location of the registration application
%        opts - the registration-specific options
%
% Output: cmds - a cell array of commands to run
%         chk_files - a cell array of files that should be there when done


% set the output suffix
sfix = '.nii.gz';
if (out_type == 1), sfix = '.nii'; end

% set some output filenames
aff_name = sprintf('%s/%s_affinemat.mtx', out_warp_dir, out_prefix);
cpp_name = sprintf('%s/%s_cpp%s', out_warp_dir, out_prefix, sfix);
seg_aff_name = sprintf('%s/%s_aff_seg%s', out_temp_dir, out_prefix, sfix);
reg_aff_name = sprintf('%s/%s_aff%s', out_temp_dir, out_prefix, sfix);
seg_name = sprintf('%s/%s_seg%s', out_seg_dir, out_prefix, sfix);
reg_name = sprintf('%s/%s%s', out_atlas_dir, out_prefix, sfix);

% set the chk_files
chk_files{1} = aff_name;
chk_files{2} = cpp_name;
chk_files{3} = seg_name;
chk_files{4} = reg_name;

% set the default options
if ~isfield(opts, 'aff_opts')
    opts.aff_opts = '';
end
if ~isfield(opts, 'nr_opts')
    opts.nr_opts = '';
end

cmds = {};

% run the niftyreg framework

% first run reg_aladin (affine alignment)
cmds{1} = sprintf('%s/reg_aladin -ref %s -flo %s -aff %s -res %s %s\n', ...
                  regloc, target, atlas, aff_name, reg_aff_name, opts.aff_opts);

% second, run reg_f3d (non-rigid alignment)
cmds{2} = sprintf('%s/reg_f3d -ref %s -flo %s -aff %s -cpp %s -res %s %s', ...
                  regloc, target, atlas, aff_name, cpp_name, reg_name, ...
                  opts.nr_opts);

% lastly, run reg_resample etransfer the labels)
cmds{3} = sprintf('%s/reg_resample -ref %s -flo %s -cpp %s -res %s -NN', ...
                  regloc, target, labels, cpp_name, seg_name);

