function [estimate W theta] = STAPLER(obs, epsilon, prior, ...
                                      init_flag, cons_flag, bias_theta)
% STAPLER - performs the STAPLER statistical label fusion algorithm
%
% Two forms:
% [estimate W theta] = STAPLER(obs, epsilon, prior_flag, init_flag, ...
%                              cons_flag, bias_theta);
% [estimate W theta] = STAPLER(obs, epsilon, sv_prior, init_flag, ...
%                              cons_flag, bias_theta);
%
% Input: obs - observation struct
%        epsilon - the convergence factor (i.e. 0.001)
%        prior_flag - the type of prior
%                   - 0 => global prior
%                   - 1 => voxelwise prior
%        sv_prior - An explicit spatially varying prior (X x Y x Z x L)
%        init_flag - the type of initialization
%                  - 0 => W then theta
%                  - 1 => theta then W
%        cons_flag - Whether or not to ignore consensus voxels
%                  - 0 => Don't Ignore
%                  - 1 => Ignore
%        bias_theta - generally an empirical biasing prior for the theta
%                     estimation. Should be of size L x L x R (where L is
%                     the number of labels and R is the number of raters).
%                     Note: The values of bias_theta are not probabilities
%                     between 0 and 1.
% Output: estimate - estimate of the true segmentation
%         W - the probability of the true segmentation for each voxel/label
%         theta - the performance level parameters
%

% create the java observation object
obsjava = create_java_obs(obs);

% run the constructor on the staple class (initialize)
s = edu.vanderbilt.masi.LabelFusion.STAPLER(obsjava, epsilon, prior, ...
                                            init_flag, cons_flag, bias_theta);

% run the STAPLER algorithm
estimate = uint8(s.run());
W = s.get_W();
theta = s.get_theta();
