function obs = add_webmill_obs(obs, fname, st_slice, varargin)
% ADD_WEBMILL_OBS - Adds an observation to a previously created observation
%                   struct using the webmill format filenames
%
% obs = add_webmill_obs(obs, filename);
%
% Input: obs - The previous observation struct
%        fname - The webmill formated png file
%        st_slice - The starting slice number
%
% Output: obs - The output observation struct with the added observation

% use regular expressions to find the parameters we need
rater = regexp(char(regexp(fname, 'rater[0-9]+', 'match')), '[0-9]+', 'match');
rater = str2num(rater{1});
sl = regexp(char(regexp(fname, 'sl[0-9]+', 'match')), '[0-9]+', 'match');
sl = str2num(sl{1});
sl = sl - st_slice + 1;

% load the data
im = imread(fname);

% check varargin
if length(varargin) > 1
    error('Wrong Last Argument');
end
if length(varargin) == 1 && (~strcmp(varargin{1}, 'odd') && ~strcmp(varargin{1}, 'even'))
    error('Wrong Last Argument');
end

if length(varargin) == 0
    obs = add_obs(obs, im, sl, rater);
elseif strcmp(varargin{1}, 'odd') && mod(sl, 2)
    sl = ceil(sl / 2);
    obs = add_obs(obs, im, sl, rater);
elseif strcmp(varargin{1}, 'even') && ~mod(sl, 2)
    sl = ceil(sl / 2);
    obs = add_obs(obs, im, sl, rater);
end

