function new_prior = apply_gaussian_filter(dims, sigma, prior)
% APPLY_GAUSSIAN_FILTER - apply a gaussian filter to the estimate of the
%                         label probabilities.
%
% Input: dims - the size of the gaussian kernel
%        sigma - the standard deviation (isotropic) of the gaussian kernel
%        prior - the initial estimate of the associated label probabilities
%
% Output: new_prior - the prior after applying the gaussian kernel to the prior
%

% set the kernel size
xm = (dims(1)+1) / 2;
ym = (dims(2)+1) / 2;
zm = (dims(3)+1) / 2;

% construct the kernel
twiceSigmaSquared = 2*sigma^2;
for x = 1:dims(1)
    for y=1:dims(2)
        for z=1:dims(3)
            radiusSquared = (x-xm)^2 + (y-ym)^2 + (z-zm)^2;
            h(x, y, z) = exp(-radiusSquared/twiceSigmaSquared);
        end
    end
end

% apply the gaussian kernel
new_prior = prior;
num_labels = size(prior, 4);
for l = 1:num_labels
    new_prior(:, :, :, l) = convn(squeeze(prior(:, :, :, l)), h, 'same');
end
new_prior = new_prior ./ repmat(sum(new_prior, 4), [1 1 1 num_labels]);
