function convert_mff_to_nii(mff_file, ref_nii_file, num_dims, typ)
% CONVERT_MFF_TO_NII - convert a mff file to the nii format
%
% convert_mff_to_nii(mff_file, ref_nii_file, num_dims, typ)
%
% Input: mff_file - the input mff filename
%        ref_nii_file - the reference nii filename (same format)
%        num_dims - the number of dimensions on the data
%        typ - the datatype of the mff file
%
% Output: (NONE)

% read the nls file
data = read_nls_file(mff_file, num_dims, typ);

% save the nii file
if strcmp(ref_nii_file(end-1:end), 'gz')
    nii = load_untouch_nii_gz(ref_nii_file);
    nii.img = data;
    save_untouch_nii_gz(nii, [mff_file(1:end-4), '.nii.gz']);
else
    nii = load_untouch_nii(ref_nii_file);
    nii.img = data;
    save_untouch_nii(nii, [mff_file(1:end-4), '.nii']);
end


